/*
 * Decompiled with CFR 0.152.
 */
package mod.crystals.api.seal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import mod.crystals.api.NatureType;
import mod.crystals.api.seal.ISeal;
import mod.crystals.api.seal.ISealInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class SealType
extends IForgeRegistryEntry.Impl<SealType> {
    public abstract int getSize();

    public ResourceLocation getTextureLocation(TextureType type) {
        int size = this.getSize();
        if (size == 0 && (type == TextureType.BASE || type == TextureType.OVERLAY)) {
            return this.getTextureName(type);
        }
        if (size == 1 && (type == TextureType.GLOW_BLACK || type == TextureType.GLOW_TRANSPARENT)) {
            return this.getTextureName(type);
        }
        return null;
    }

    protected ResourceLocation getTextureName(TextureType type) {
        if (type == TextureType.BASE) {
            return new ResourceLocation("crystals", "textures/seals/base/small.png");
        }
        ResourceLocation name = this.getRegistryName();
        return new ResourceLocation(name.func_110624_b(), "textures/seals/" + name.func_110623_a() + "/" + type.getName() + ".png");
    }

    public float getRotationSpeed() {
        return this.getSize() == 0 ? 0.0f : 1.0f;
    }

    public int getTint() {
        return 0xFFFFFF;
    }

    public abstract Ingredient[][] createRecipe();

    public abstract ISealInstance instantiate(ISeal var1);

    public static final class Ingredient {
        private final Set<NatureType> natureTypes = new HashSet<NatureType>();

        public Ingredient(NatureType ... natureTypes) {
            if (natureTypes.length > 4) {
                throw new IllegalArgumentException("An ingredient must have 4 nature types at most!");
            }
            this.natureTypes.addAll(Arrays.asList(natureTypes));
        }

        public boolean matches(Set<NatureType> natureTypes) {
            return natureTypes.size() == this.natureTypes.size() && natureTypes.containsAll(this.natureTypes);
        }
    }

    public static enum TextureType {
        BASE("small"),
        OVERLAY("overlay"),
        GLOW_BLACK("glow_black"),
        GLOW_TRANSPARENT("glow");

        private final String name;

        private TextureType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

