/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.atomicworkshop.jammachine.JamMachineMod;

public final class CollisionMaths {
    private CollisionMaths() {
    }

    public static Vec3d intersectionLinePlane(Vec3d head, Vec3d look, Vec3d planeOrigin, Vec3d planeNormal) {
        double dot = planeNormal.func_72430_b(look);
        if ((double)MathHelper.func_76135_e((float)((float)dot)) > 1.0E-6) {
            Vec3d w = head.func_178788_d(planeOrigin);
            double factor = -planeNormal.func_72430_b(w) / dot;
            return head.func_178787_e(look.func_186678_a(factor));
        }
        return null;
    }

    public static Vec3d calculateSlopeHit(BlockPos pos, EnumFacing blockFacing, EntityPlayer player) {
        Vec3d finalHitVector;
        Vec3d bottomRightCorner;
        Vec3d bottomLeft;
        Vec3d planeOrigin;
        Vec3d headPosition = CollisionMaths.getPlayerHeadPosition(player);
        Vec3d lookVector = CollisionMaths.getPlayerLookVector(player);
        switch (blockFacing) {
            case NORTH: {
                planeOrigin = new Vec3d((double)(pos.func_177958_n() + 1), (double)((float)pos.func_177956_o() + 0.46875f), (double)((float)pos.func_177952_p() + 0.984375f));
                bottomLeft = new Vec3d((double)(pos.func_177958_n() + 1), (double)((float)pos.func_177956_o() + 0.0625f), (double)pos.func_177952_p());
                bottomRightCorner = new Vec3d((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 0.0625f), (double)pos.func_177952_p());
                break;
            }
            case SOUTH: {
                planeOrigin = new Vec3d((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 0.46875f), (double)((float)pos.func_177952_p() + 0.015625f));
                bottomLeft = new Vec3d((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 0.0625f), (double)(pos.func_177952_p() + 1));
                bottomRightCorner = new Vec3d((double)(pos.func_177958_n() + 1), (double)((float)pos.func_177956_o() + 0.0625f), (double)(pos.func_177952_p() + 1));
                break;
            }
            case WEST: {
                planeOrigin = new Vec3d((double)((float)pos.func_177958_n() + 0.984375f), (double)((float)pos.func_177956_o() + 0.46875f), (double)pos.func_177952_p());
                bottomLeft = new Vec3d((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 0.0625f), (double)pos.func_177952_p());
                bottomRightCorner = new Vec3d((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 0.0625f), (double)(pos.func_177952_p() + 1));
                break;
            }
            case EAST: {
                planeOrigin = new Vec3d((double)((float)pos.func_177958_n() + 0.015625f), (double)((float)pos.func_177956_o() + 0.46875f), (double)(pos.func_177952_p() + 1));
                bottomLeft = new Vec3d((double)(pos.func_177958_n() + 1), (double)((float)pos.func_177956_o() + 0.0625f), (double)(pos.func_177952_p() + 1));
                bottomRightCorner = new Vec3d((double)(pos.func_177958_n() + 1), (double)((float)pos.func_177956_o() + 0.0625f), (double)pos.func_177952_p());
                break;
            }
            default: {
                return null;
            }
        }
        Vec3d u = bottomLeft.func_178788_d(planeOrigin);
        Vec3d v = bottomRightCorner.func_178788_d(planeOrigin);
        Vec3d planeNormal = u.func_72431_c(v);
        Vec3d vector3d = CollisionMaths.intersectionLinePlane(headPosition, lookVector, planeOrigin, planeNormal);
        if (vector3d == null) {
            JamMachineMod.logger.info("player missed");
            return null;
        }
        Vec3d hitVector = vector3d.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        switch (blockFacing) {
            case NORTH: {
                finalHitVector = new Vec3d(1.0 - hitVector.field_72450_a, hitVector.field_72448_b, 1.0 - hitVector.field_72449_c);
                break;
            }
            case SOUTH: {
                finalHitVector = hitVector;
                break;
            }
            case WEST: {
                finalHitVector = new Vec3d(hitVector.field_72449_c, hitVector.field_72448_b, 1.0 - hitVector.field_72450_a);
                break;
            }
            case EAST: {
                finalHitVector = new Vec3d(1.0 - hitVector.field_72449_c, hitVector.field_72448_b, hitVector.field_72450_a);
                break;
            }
            default: {
                finalHitVector = hitVector;
            }
        }
        JamMachineMod.logger.info("player clicked at {},{},{}", (Object)finalHitVector.field_72450_a, (Object)finalHitVector.field_72448_b, (Object)finalHitVector.field_72449_c);
        return finalHitVector;
    }

    public static Vec3d getPlayerLookVector(EntityPlayer playerIn) {
        float playerPitch = playerIn.field_70125_A;
        float playerYaw = playerIn.field_70177_z;
        float yawCosine = MathHelper.func_76134_b((float)((float)((double)(-playerYaw) * (Math.PI / 180) - Math.PI)));
        float yawSine = MathHelper.func_76126_a((float)((float)((double)(-playerYaw) * (Math.PI / 180) - Math.PI)));
        float pitchCosine = -MathHelper.func_76134_b((float)((float)((double)(-playerPitch) * (Math.PI / 180))));
        float pitchSine = MathHelper.func_76126_a((float)((float)((double)(-playerPitch) * (Math.PI / 180))));
        float lookX = yawSine * pitchCosine;
        float lookZ = yawCosine * pitchCosine;
        float playerReach = (float)playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d lookVector = new Vec3d((double)(lookX * playerReach), (double)(pitchSine * playerReach), (double)(lookZ * playerReach));
        return lookVector;
    }

    public static Vec3d getPlayerHeadPosition(EntityPlayer playerIn) {
        Vec3d headPosition = new Vec3d(playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v);
        return headPosition;
    }
}

