/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.tiles;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import org.atomicworkshop.jammachine.JamMachineMod;
import org.atomicworkshop.jammachine.Reference;
import org.atomicworkshop.jammachine.libraries.ItemLibrary;
import org.atomicworkshop.jammachine.sequencing.MusicPlayer;
import org.atomicworkshop.jammachine.sequencing.Pattern;
import org.atomicworkshop.jammachine.sequencing.Sequencer;
import org.atomicworkshop.jammachine.sequencing.SequencerSet;

public class TileEntitySequencer
extends TileEntity
implements ITickable {
    private static final int IS_PLAYING = 0;
    private static final int CHANGE_PATTERN = 1;
    private boolean hasCard = false;
    private UUID sequencerSetId = UUID.randomUUID();
    private Sequencer sequencer = null;
    private boolean isPlaying;

    private boolean hasController() {
        return false;
    }

    public boolean getHasCard() {
        return this.hasCard;
    }

    public void setHasCard(boolean iHasCard) {
        this.hasCard = iHasCard;
        this.sendUpdates();
    }

    public void onChunkUnload() {
        this.stopPlaying();
    }

    protected void func_190201_b(World worldIn) {
        this.func_145834_a(worldIn);
    }

    public void func_145839_a(NBTTagCompound compound) {
        JamMachineMod.logger.info("read from NBT");
        super.func_145839_a(compound);
        boolean wasPlaying = this.isPlaying;
        this.isPlaying = compound.func_74767_n("isPlaying");
        this.hasCard = compound.func_74767_n(Reference.NBT.hasCard);
        this.sequencerSetId = compound.func_186857_a(Reference.NBT.songId);
        if (this.sequencerSetId.equals(Reference.EMPTY_UUID)) {
            this.sequencerSetId = UUID.randomUUID();
        }
        this.readCustomDataFromNBT(compound);
        this.updatePlayStatus(wasPlaying);
    }

    private void readCustomDataFromNBT(NBTTagCompound compound) {
        NBTTagCompound compoundTag = compound.func_74775_l(Reference.NBT.sequence);
        if (!compoundTag.func_82582_d()) {
            if (this.sequencer == null) {
                this.sequencer = new Sequencer(this.field_145850_b, this.field_174879_c);
                MusicPlayer.startTracking(this.sequencer);
            }
            this.sequencer.readFromNBT(compoundTag);
            JamMachineMod.logger.info("compoundTag: {}", (Object)compoundTag);
            if (this.sequencer.getBeatsPerMinute() < 60) {
                this.sequencer.setDesiredBPM(120);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("isPlaying", this.isPlaying);
        compound.func_74757_a(Reference.NBT.hasCard, this.hasCard);
        compound.func_186854_a(Reference.NBT.songId, this.sequencerSetId);
        this.writeCustomDataToNBT(compound);
        JamMachineMod.logger.info("writing to NBT");
        return compound;
    }

    private NBTTagCompound writeCustomDataToNBT(NBTTagCompound compound) {
        if (this.sequencer != null) {
            compound.func_74782_a(Reference.NBT.sequence, (NBTBase)this.sequencer.writeToNBT());
        }
        return compound;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound updateTag = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, updateTag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        boolean wasPlaying = this.isPlaying;
        this.handleUpdateTag(pkt.func_148857_g());
        this.updatePlayStatus(wasPlaying);
    }

    private void updatePlayStatus(boolean wasPlaying) {
        if (this.isPlaying && !wasPlaying) {
            this.startPlaying();
        } else if (!this.isPlaying && wasPlaying) {
            this.stopPlaying();
        }
    }

    private void startPlaying() {
        if (this.field_145850_b == null || this.field_174879_c == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        SequencerSet sequencerSet = !this.hasController() ? new SequencerSet(this.sequencerSetId) : new SequencerSet(this.sequencerSetId);
        sequencerSet.addSequencer(this.sequencer);
        sequencerSet.updateBpm();
        boolean updateBlock = false;
        for (EnumFacing horizontal : EnumFacing.field_176754_o) {
            updateBlock |= this.sequencer.verifyNoteBlockFacing(horizontal);
        }
        if (updateBlock) {
            this.sendUpdates();
        }
        MusicPlayer.playSong(sequencerSet);
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 0, 1);
    }

    private void sendUpdates() {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return;
        }
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public void stopPlaying() {
        if (this.sequencer != null) {
            this.sequencer.setCurrentInterval(-1);
        }
        MusicPlayer.stopPlaying(this.sequencerSetId);
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 0, 0);
    }

    public void notifyPowered(boolean powered) {
        if (this.isPlaying != powered) {
            this.isPlaying = powered;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 0, this.isPlaying ? 1 : 0);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 0) {
            boolean wasPlaying = this.isPlaying;
            this.isPlaying = type != 0;
            this.updatePlayStatus(wasPlaying);
            return true;
        }
        if (id == 1) {
            this.sequencer.setPendingPatternIndex(type);
            if (!this.isPlaying) {
                this.sequencer.setCurrentPatternIndex(type);
            }
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (this.sequencer == null) {
            return;
        }
        int blockToCheck = (int)(this.field_145850_b.func_82737_E() & 3L);
        EnumFacing facing = EnumFacing.func_176731_b((int)blockToCheck);
        this.sequencer.verifyNoteBlockFacing(facing);
    }

    public void loadFromCard(ItemStack heldItemStack) {
        if (heldItemStack.func_77978_p() != null) {
            this.readCustomDataFromNBT(heldItemStack.func_77978_p());
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdates();
        }
    }

    public ItemStack saveToCard() {
        ItemStack i = new ItemStack((Item)ItemLibrary.punchCardWritten, 1);
        i.func_77982_d(this.writeCustomDataToNBT(new NBTTagCompound()));
        return i;
    }

    public boolean checkPlayerInteraction(double x, double z, EntityPlayer playerIn) {
        double backX = x;
        double backZ = z;
        if (x < 0.0 || x > 1.0 || z < 0.0 || z > 1.0) {
            return false;
        }
        JamMachineMod.logger.info("adjusted hitlocation {},{}", (Object)x, (Object)z);
        x *= 28.0;
        z *= 29.0;
        JamMachineMod.logger.info("checking player interaction at scaled {},{}", (Object)(x -= 2.5), (Object)(z -= 0.5));
        if (x >= 0.0 && x < 16.0 && z >= 0.0 && z < 26.0) {
            if (this.sequencer == null) {
                this.sequencer = new Sequencer(this.field_145850_b, this.field_174879_c);
                MusicPlayer.startTracking(this.sequencer);
            }
            Pattern currentPattern = this.sequencer.getCurrentPattern();
            int pitch = 25 - (int)z;
            int interval = (int)x;
            boolean isEnabled = currentPattern.invertPitchAtInternal(interval, pitch);
            JamMachineMod.logger.info("Inverting pitch {} at interval {} - {}", (Object)pitch, (Object)interval, (Object)isEnabled);
            if (!this.field_145850_b.field_72995_K) {
                this.sendUpdates();
            }
            return true;
        }
        if (this.hasCard && backX >= 0.7192042839004351 && backX <= 0.9325510942881259 && backZ >= 0.8448828111319173 && backZ <= 0.9298803321497289) {
            this.ejectCard(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v);
            return true;
        }
        if (backX >= 0.7062424864522878 && backX <= 0.9593446274414177 && backZ >= 0.43397610552808197 && backZ <= 0.5463901310950732) {
            double bankWidth = 0.25310214098912986;
            double bankHeight = 0.1124140255669912;
            double offX = backX - 0.7062424864522878;
            double offZ = backZ - 0.43397610552808197;
            int index = 0;
            index = offX < bankWidth / 4.0 ? (offZ < bankHeight / 2.0 ? 0 : 4) : (offX < bankWidth / 2.0 ? (offZ < bankHeight / 2.0 ? 1 : 5) : (offX < bankWidth * 3.0 / 4.0 ? (offZ < bankHeight / 2.0 ? 2 : 6) : (offZ < bankHeight / 2.0 ? 3 : 7)));
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, index);
            this.sequencer.setPendingPatternIndex(index);
            if (!this.isPlaying) {
                this.sequencer.setCurrentPatternIndex(index);
            }
            return true;
        }
        if (backX >= 0.7045204265288701 && backX <= 0.9327918869342732 && backZ >= 0.21970650094097977 && backZ <= 0.2705630830397361) {
            double offX = backX - 0.7045204265288701;
            double bpmUIWidth = 0.22827146040540303;
            if (offX <= bpmUIWidth / 4.0) {
                if (this.sequencer.getBeatsPerMinute() > 10) {
                    this.sequencer.setDesiredBPM(this.sequencer.getBeatsPerMinute() - 10);
                    if (!this.field_145850_b.field_72995_K) {
                        this.sendUpdates();
                    }
                    return true;
                }
            } else if (offX <= bpmUIWidth / 2.0) {
                if (this.sequencer.getBeatsPerMinute() > 1) {
                    this.sequencer.setDesiredBPM(this.sequencer.getBeatsPerMinute() - 1);
                    if (!this.field_145850_b.field_72995_K) {
                        this.sendUpdates();
                    }
                    return true;
                }
            } else if (offX <= bpmUIWidth * 3.0 / 4.0) {
                if (this.sequencer.getBeatsPerMinute() < 240) {
                    this.sequencer.setDesiredBPM(this.sequencer.getBeatsPerMinute() + 1);
                    if (!this.field_145850_b.field_72995_K) {
                        this.sendUpdates();
                    }
                    return true;
                }
            } else if (this.sequencer.getBeatsPerMinute() < 230) {
                this.sequencer.setDesiredBPM(this.sequencer.getBeatsPerMinute() + 10);
                if (!this.field_145850_b.field_72995_K) {
                    this.sendUpdates();
                }
                return true;
            }
        }
        return false;
    }

    public void ejectCard(double x, double y, double z) {
        JamMachineMod.logger.info("Eject Card");
        ItemStack card = this.saveToCard();
        if (!this.field_145850_b.field_72995_K) {
            EntityItem entityitem = new EntityItem(this.field_145850_b, x, y + 0.5, z, card);
            entityitem.func_174869_p();
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
        this.setHasCard(false);
    }

    public Sequencer getSequencer() {
        if (this.sequencer == null && this.field_145850_b != null && this.field_174879_c != null) {
            this.sequencer = new Sequencer(this.field_145850_b, this.field_174879_c);
        }
        return this.sequencer;
    }
}

