/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.tiles;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.atomicworkshop.jammachine.JamMachineMod;
import org.atomicworkshop.jammachine.Reference;
import org.atomicworkshop.jammachine.sequencing.ControllerPattern;
import org.atomicworkshop.jammachine.sequencing.JamController;
import org.atomicworkshop.jammachine.sequencing.MusicPlayer;
import org.atomicworkshop.jammachine.sequencing.Sequencer;

public class TileEntityController
extends TileEntity {
    private static final int IS_PLAYING = 0;
    private static final int CHANGE_SECTION = 2;
    private boolean hasCard = false;
    private UUID sequencerSetId;
    private JamController jamController = null;
    private boolean isPlaying;
    private int displayedSection = 0;
    private final ControllerPattern[] selectedSequencers = new ControllerPattern[2];

    public ControllerPattern getSelectedSequence(int index) {
        ControllerPattern selectedSequencer = this.selectedSequencers[index &= 1];
        if (selectedSequencer != null) {
            return selectedSequencer;
        }
        if (this.jamController == null) {
            this.jamController = new JamController(this.field_145850_b, this.field_174879_c);
        }
        this.jamController.findSequencers();
        int alternateIndex = 1 - index;
        ControllerPattern alternativeSequencer = this.selectedSequencers[alternateIndex];
        for (Sequencer sequencer : this.jamController) {
            if (alternativeSequencer != null && alternativeSequencer.getSequencerId().equals(sequencer.getId())) continue;
            selectedSequencer = this.jamController.getControllerPatternForId(sequencer.getId());
        }
        if (selectedSequencer != null) {
            this.selectedSequencers[index] = selectedSequencer;
        }
        return selectedSequencer;
    }

    public TileEntityController() {
        this.sequencerSetId = UUID.randomUUID();
    }

    public int getDisplayedSection() {
        return this.displayedSection;
    }

    public long getBeatsPerMinute() {
        if (this.jamController != null) {
            return this.jamController.getBeatsPerMinute();
        }
        return 120L;
    }

    public void onChunkUnload() {
        this.stopPlaying();
    }

    protected void func_190201_b(World worldIn) {
        this.func_145834_a(worldIn);
    }

    public void func_145839_a(NBTTagCompound compound) {
        JamMachineMod.logger.info("read from NBT");
        super.func_145839_a(compound);
        boolean wasPlaying = this.isPlaying;
        this.isPlaying = compound.func_74767_n("isPlaying");
        this.hasCard = compound.func_74767_n(Reference.NBT.hasCard);
        if (this.jamController == null) {
            this.jamController = new JamController(this.field_145850_b, this.field_174879_c);
            MusicPlayer.startTracking(this.jamController);
        }
        this.readCustomDataFromNBT(compound);
        this.updatePlayStatus(wasPlaying);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        JamMachineMod.logger.info("writing to NBT");
        super.func_189515_b(compound);
        compound.func_74757_a("isPlaying", this.isPlaying);
        compound.func_74757_a(Reference.NBT.hasCard, this.hasCard);
        compound.func_186854_a(Reference.NBT.songId, this.sequencerSetId);
        this.writeCustomDataToNBT(compound);
        return compound;
    }

    private void writeCustomDataToNBT(NBTTagCompound compound) {
        if (this.jamController != null) {
            compound.func_74782_a(Reference.NBT.sequence, this.jamController.writeToNBT());
        }
    }

    private void readCustomDataFromNBT(NBTTagCompound compound) {
        NBTTagCompound compoundTag = compound.func_74775_l(Reference.NBT.sequence);
        if (!compoundTag.func_82582_d()) {
            this.jamController.readFromNBT(compoundTag);
            JamMachineMod.logger.info("compoundTag: {}", (Object)compoundTag);
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound updateTag = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, updateTag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        boolean wasPlaying = this.isPlaying;
        this.handleUpdateTag(pkt.func_148857_g());
        this.updatePlayStatus(wasPlaying);
    }

    private void updatePlayStatus(boolean wasPlaying) {
        if (this.isPlaying && !wasPlaying) {
            this.startPlaying();
        } else if (!this.isPlaying && wasPlaying) {
            this.stopPlaying();
        }
    }

    private void startPlaying() {
        if (this.field_145850_b == null || this.field_174879_c == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        this.jamController.updateBpm();
        boolean updateBlock = false;
        for (EnumFacing horizontal : EnumFacing.field_176754_o) {
            for (Sequencer sequencer : this.jamController) {
                updateBlock |= sequencer.verifyNoteBlockFacing(horizontal);
            }
        }
        if (updateBlock) {
            this.sendUpdates();
        }
        MusicPlayer.playSong(this.jamController);
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 0, 1);
    }

    private void sendUpdates() {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return;
        }
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public void stopPlaying() {
        if (this.jamController != null) {
            MusicPlayer.stopPlaying(this.jamController.getId());
        }
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 0, 0);
    }

    public void notifyPowered(boolean powered) {
        if (this.isPlaying != powered) {
            this.isPlaying = powered;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 0, this.isPlaying ? 1 : 0);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 0) {
            boolean wasPlaying = this.isPlaying;
            this.isPlaying = type != 0;
            this.updatePlayStatus(wasPlaying);
            return true;
        }
        if (id == 2) {
            this.displayedSection = type;
            return true;
        }
        return false;
    }

    public JamController getController() {
        return this.jamController;
    }

    public boolean hasCard() {
        return this.hasCard;
    }
}

