/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.tesr;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.atomicworkshop.jammachine.libraries.ItemLibrary;
import org.atomicworkshop.jammachine.sequencing.JamController;
import org.atomicworkshop.jammachine.sequencing.Pattern;
import org.atomicworkshop.jammachine.sequencing.Sequencer;
import org.atomicworkshop.jammachine.tiles.TileEntityController;

public class TESRBlockController
extends TileEntitySpecialRenderer<TileEntityController> {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final ItemStack disabledItemInactiveInterval = new ItemStack(Blocks.field_192443_dR, 1, EnumDyeColor.SILVER.func_176765_a());
    private final ItemStack enabledItemInactiveInterval = new ItemStack(Blocks.field_192443_dR, 1, EnumDyeColor.BROWN.func_176765_a());
    private final ItemStack disabledItemActiveInterval = new ItemStack(Blocks.field_192443_dR, 1, EnumDyeColor.WHITE.func_176765_a());
    private final ItemStack enabledItemActiveInterval = new ItemStack(Blocks.field_192443_dR, 1, EnumDyeColor.YELLOW.func_176765_a());
    private final ItemStack disabledItemInactiveIntervalSharp = new ItemStack(Blocks.field_192443_dR, 1, EnumDyeColor.BLACK.func_176765_a());
    private final ItemStack enabledItemInactiveIntervalSharp = new ItemStack(Blocks.field_192443_dR, 1, EnumDyeColor.BROWN.func_176765_a());
    private final ItemStack disabledItemActiveIntervalSharp = new ItemStack(Blocks.field_192443_dR, 1, EnumDyeColor.GRAY.func_176765_a());
    private final ItemStack enabledItemActiveIntervalSharp = new ItemStack(Blocks.field_192443_dR, 1, EnumDyeColor.ORANGE.func_176765_a());
    private final ItemStack punchCard = new ItemStack((Item)ItemLibrary.punchCardBlank, 1, 0);
    private final float disabledButtonHeight = 0.015f;

    public void render(TileEntityController te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te == null) {
            return;
        }
        JamController controller = te.getController();
        if (controller == null) {
            return;
        }
        int facing = te.func_145832_p();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179114_b((float)(-90 * facing), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)23.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.2, (double)-0.5);
        float scale = 0.035714287f;
        GlStateManager.func_179152_a((float)0.035714287f, (float)0.035714287f, (float)0.035714287f);
        GlStateManager.func_179137_b((double)3.0, (double)0.0, (double)3.5);
        this.drawBPM(controller.getBeatsPerMinute());
        GlStateManager.func_179123_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)true);
        this.renderBPMButtons(controller);
        if (te.hasCard()) {
            this.renderCard();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    private void renderPatternButtons(Sequencer sequencer) {
        RenderItem itemRenderer = mc.func_175599_af();
        int currentPatternIndex = sequencer.getCurrentPatternIndex();
        int pendingPatternIndex = sequencer.getPendingPatternIndex();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)18.5, (double)0.0, (double)12.0);
        for (int patternIndex = 0; patternIndex < 8; ++patternIndex) {
            int patternButtonX = patternIndex & 3;
            int patternButtonY = (patternIndex & 4) >> 2;
            boolean isEnabled = patternIndex == pendingPatternIndex;
            boolean isCurrent = patternIndex == currentPatternIndex;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)patternButtonX, (float)(isEnabled ? 0.0f : 0.015f), (float)patternButtonY);
            if (isCurrent) {
                itemRenderer.func_181564_a(this.enabledItemActiveInterval, ItemCameraTransforms.TransformType.FIXED);
            } else if (isEnabled) {
                itemRenderer.func_181564_a(this.enabledItemInactiveInterval, ItemCameraTransforms.TransformType.FIXED);
            } else {
                itemRenderer.func_181564_a(this.disabledItemInactiveInterval, ItemCameraTransforms.TransformType.FIXED);
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private void renderBPMButtons(JamController controller) {
        RenderItem itemRenderer = mc.func_175599_af();
        int bpm = controller.getBeatsPerMinute();
        FontRenderer fontrenderer = this.func_147498_b();
        float textScale = 0.05f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)17.8, (double)0.0, (double)5.3);
        GlStateManager.func_179139_a((double)2.7, (double)2.0, (double)2.7);
        itemRenderer.func_181564_a(this.enabledItemInactiveInterval, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.3, (double)-0.2);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.05f, (float)-0.05f, (float)0.05f);
        String minus10 = "<<";
        fontrenderer.func_78276_b("<<", -fontrenderer.func_78256_a("<<") / 2, 0, 0xFFFFFF);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)0.6, (double)0.0, (double)0.0);
        itemRenderer.func_181564_a(this.enabledItemInactiveInterval, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.3, (double)-0.2);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.05f, (float)-0.05f, (float)0.05f);
        String minus1 = "<";
        fontrenderer.func_78276_b("<", -fontrenderer.func_78256_a("<") / 2, 0, 0xFFFFFF);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)0.6, (double)0.0, (double)0.0);
        itemRenderer.func_181564_a(this.enabledItemInactiveInterval, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.3, (double)-0.2);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.05f, (float)-0.05f, (float)0.05f);
        String plus1 = ">";
        fontrenderer.func_78276_b(">", -fontrenderer.func_78256_a(">") / 2, 0, 0xFFFFFF);
        GlStateManager.func_179121_F();
        GlStateManager.func_179137_b((double)0.6, (double)0.0, (double)0.0);
        itemRenderer.func_181564_a(this.enabledItemInactiveInterval, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.3, (double)-0.2);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.05f, (float)-0.05f, (float)0.05f);
        String plus10 = ">>";
        fontrenderer.func_78276_b(">>", -fontrenderer.func_78256_a(">>") / 2, 0, 0xFFFFFF);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private void renderSequence(Sequencer sequencer) {
        RenderItem itemRenderer = mc.func_175599_af();
        Pattern p = sequencer.getCurrentPattern();
        GlStateManager.func_179094_E();
        for (int interval = 0; interval < 16; ++interval) {
            boolean[] rawPatternData = p.getRawPatternData(interval);
            for (int pitch = 0; pitch < 24; ++pitch) {
                boolean isEnabled = rawPatternData[pitch];
                ItemStack renderItem = this.getSequenceButtonColour(sequencer, interval, pitch, isEnabled);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)interval, (float)(isEnabled ? 0.0f : 0.015f), (float)(25 - pitch));
                itemRenderer.func_181564_a(renderItem, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179121_F();
    }

    private ItemStack getSequenceButtonColour(Sequencer sequencer, int interval, int pitch, boolean isEnabled) {
        int currentInterval = sequencer.getCurrentInterval();
        if (TESRBlockController.isSharpPitch(pitch)) {
            if (currentInterval == interval) {
                return isEnabled ? this.enabledItemActiveIntervalSharp : this.disabledItemActiveIntervalSharp;
            }
            return isEnabled ? this.enabledItemInactiveIntervalSharp : this.disabledItemInactiveIntervalSharp;
        }
        if (currentInterval == interval) {
            return isEnabled ? this.enabledItemActiveInterval : this.disabledItemActiveInterval;
        }
        return isEnabled ? this.enabledItemInactiveInterval : this.disabledItemInactiveInterval;
    }

    private void renderCard() {
        RenderItem itemRenderer = mc.func_175599_af();
        float cardScale = 5.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)20.25, (double)0.0, (double)25.0);
        GlStateManager.func_179152_a((float)5.0f, (float)5.0f, (float)5.0f);
        itemRenderer.func_181564_a(this.punchCard, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
    }

    private void drawBPM(int bpm) {
        FontRenderer fontrenderer = this.func_147498_b();
        float textScale = 0.3f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)20.0, (double)0.09, (double)1.5);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.3f, (float)-0.3f, (float)0.3f);
        String bpmText = String.valueOf(bpm);
        fontrenderer.func_78276_b(bpmText, -fontrenderer.func_78256_a(bpmText) / 2, 0, 0xFFFFFF);
        GlStateManager.func_179121_F();
    }

    private static boolean isSharpPitch(int pitch) {
        return pitch == 0 || pitch == 2 || pitch == 4 || pitch == 7 || pitch == 9 || pitch == 12 || pitch == 14 || pitch == 16 || pitch == 19 || pitch == 21 || pitch == 24;
    }
}

