/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.sequencing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.atomicworkshop.jammachine.sequencing.Sequencer;

public class SequencerSet
implements Iterable<Sequencer> {
    private int beatsPerMinute;
    private List<Sequencer> sequencers = Lists.newArrayList();
    private final Object listLock = new Object();
    private final UUID id;

    public SequencerSet(UUID id) {
        this.id = id;
    }

    public void updateBpm() {
        for (Sequencer sequencer : this.sequencers) {
            if (sequencer.getBeatsPerMinute() <= 0) continue;
            this.beatsPerMinute = Math.max(sequencer.getBeatsPerMinute(), this.beatsPerMinute);
        }
    }

    public int getBeatsPerMinute() {
        return this.beatsPerMinute;
    }

    @Override
    public Iterator<Sequencer> iterator() {
        return this.sequencers.iterator();
    }

    @Override
    public void forEach(Consumer<? super Sequencer> consumer) {
        this.sequencers.forEach(consumer);
    }

    @Override
    public Spliterator<Sequencer> spliterator() {
        return this.sequencers.spliterator();
    }

    public UUID getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSequencer(Sequencer sequencer) {
        Object object = this.listLock;
        synchronized (object) {
            ArrayList sequencers = Lists.newArrayList(this.sequencers);
            sequencers.add(sequencer);
            this.sequencers = sequencers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removingSequencer(Sequencer sequencer) {
        Object object = this.listLock;
        synchronized (object) {
            ArrayList sequencers = Lists.newArrayList(this.sequencers);
            sequencers.remove(sequencer);
            this.sequencers = sequencers;
        }
    }

    public void readFromNBT(NBTTagCompound compoundTag) {
    }

    public NBTBase writeToNBT() {
        return null;
    }

    public void marchInterval() {
    }

    public int getCurrentPatternIndexForSequencer(UUID id) {
        for (Sequencer sequencer : this.sequencers) {
            if (!sequencer.getId().equals(id)) continue;
            return sequencer.getCurrentPatternIndex();
        }
        return 0;
    }
}

