/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.sequencing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.NoteBlockEvent;
import org.atomicworkshop.jammachine.Reference;
import org.atomicworkshop.jammachine.sequencing.AdjacentNoteBlock;
import org.atomicworkshop.jammachine.sequencing.Pattern;

public class Sequencer {
    private final World world;
    private final BlockPos blockPos;
    private final Pattern[] patterns;
    private final AdjacentNoteBlock[] adjacentNoteBlocks;
    private UUID id;
    private ImmutableList<AdjacentNoteBlock> currentAdjacentNoteBlocks = ImmutableList.of();
    private int beatsPerMinute;
    private int pendingPatternIndex;
    private int currentPatternIndex;
    private int currentInterval = -1;
    private int noteBlockSearch;

    public Sequencer(World world, BlockPos blockPos) {
        this.world = world;
        this.blockPos = blockPos;
        this.adjacentNoteBlocks = new AdjacentNoteBlock[]{new AdjacentNoteBlock(EnumFacing.NORTH), new AdjacentNoteBlock(EnumFacing.EAST), new AdjacentNoteBlock(EnumFacing.SOUTH), new AdjacentNoteBlock(EnumFacing.WEST)};
        this.patterns = new Pattern[8];
        for (int i = 0; i < 8; ++i) {
            this.patterns[i] = new Pattern();
        }
        this.beatsPerMinute = 120;
        this.id = UUID.randomUUID();
    }

    private void setAdjacentNoteBlock(EnumFacing direction, NoteBlockEvent.Instrument sound) {
        this.adjacentNoteBlocks[direction.func_176736_b()].setInstrument(sound);
        ArrayList availableNoteBlocks = Lists.newArrayList();
        for (AdjacentNoteBlock adjacentNoteBlock : this.adjacentNoteBlocks) {
            if (!adjacentNoteBlock.canPlay()) continue;
            availableNoteBlocks.add(adjacentNoteBlock);
        }
        this.currentAdjacentNoteBlocks = ImmutableList.copyOf((Collection)availableNoteBlocks);
    }

    private NoteBlockEvent.Instrument getInstrumentFromNoteBlock(EnumFacing direction) {
        return this.adjacentNoteBlocks[direction.func_176736_b()].getInstrument();
    }

    BlockPos getBlockPos() {
        return this.blockPos;
    }

    public UUID getId() {
        return this.id;
    }

    public void setDesiredBPM(int beatsPerMinute) {
        this.beatsPerMinute = beatsPerMinute;
    }

    public int getBeatsPerMinute() {
        return this.beatsPerMinute;
    }

    public int getPendingPatternIndex() {
        return this.pendingPatternIndex;
    }

    public void setPendingPatternIndex(int pendingPatternIndex) {
        if (pendingPatternIndex > this.patterns.length) {
            pendingPatternIndex %= this.patterns.length;
        }
        this.pendingPatternIndex = pendingPatternIndex;
    }

    public void setCurrentPatternIndex(int currentPatternIndex) {
        if (currentPatternIndex > this.patterns.length) {
            currentPatternIndex %= this.patterns.length;
        }
        this.currentPatternIndex = currentPatternIndex;
    }

    public int getCurrentPatternIndex() {
        return this.currentPatternIndex;
    }

    public void updatePendingPattern() {
        this.currentPatternIndex = this.pendingPatternIndex;
    }

    public Pattern getCurrentPattern() {
        return this.patterns[this.currentPatternIndex];
    }

    public ImmutableList<AdjacentNoteBlock> getAvailableNoteBlocks() {
        return this.currentAdjacentNoteBlocks;
    }

    public World getWorld() {
        return this.world;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.id = compound.func_186857_a(Reference.NBT.sequencerId);
        if (this.id.equals(Reference.EMPTY_UUID)) {
            this.id = UUID.randomUUID();
        }
        this.beatsPerMinute = compound.func_74762_e(Reference.NBT.beatsPerMinute);
        this.currentPatternIndex = compound.func_74762_e(Reference.NBT.currentPatternIndex);
        this.pendingPatternIndex = compound.func_74762_e(Reference.NBT.pendingPatternIndex);
        NBTTagList nbtPatterns = compound.func_150295_c(Reference.NBT.pattern, 10);
        for (int patternIndex = 0; patternIndex < this.patterns.length; ++patternIndex) {
            NBTTagCompound patternNBT = nbtPatterns.func_150305_b(patternIndex);
            Pattern pattern = this.patterns[patternIndex];
            for (int interval = 0; interval < 16; ++interval) {
                byte[] pitchesAtInterval = patternNBT.func_74770_j(String.valueOf(interval));
                for (int i = 0; i < 25; ++i) {
                    pattern.resetPitchAtInterval(interval, i);
                }
                for (byte pitch : pitchesAtInterval) {
                    pattern.setPitchAtInternal(interval, pitch);
                }
            }
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_186854_a(Reference.NBT.sequencerId, this.id);
        tagCompound.func_74768_a(Reference.NBT.beatsPerMinute, this.beatsPerMinute);
        tagCompound.func_74768_a(Reference.NBT.currentPatternIndex, this.currentPatternIndex);
        tagCompound.func_74768_a(Reference.NBT.pendingPatternIndex, this.pendingPatternIndex);
        NBTTagList patternList = new NBTTagList();
        for (int patternIndex = 0; patternIndex < this.patterns.length; ++patternIndex) {
            Pattern pattern = this.patterns[patternIndex];
            NBTTagCompound patternNBT = new NBTTagCompound();
            for (int interval = 0; interval < 16; ++interval) {
                Iterable<Byte> pitchesAtInterval = pattern.getPitchesAtInterval(interval);
                ArrayList pitchList = Lists.newArrayList(pitchesAtInterval);
                if (pitchList.isEmpty()) continue;
                NBTTagByteArray pitchArray = new NBTTagByteArray((List)pitchList);
                patternNBT.func_74782_a(String.valueOf(interval), (NBTBase)pitchArray);
            }
            patternList.func_74742_a((NBTBase)patternNBT);
        }
        tagCompound.func_74782_a(Reference.NBT.pattern, (NBTBase)patternList);
        return tagCompound;
    }

    public int getCurrentInterval() {
        return this.currentInterval;
    }

    public void setCurrentInterval(int currentInterval) {
        this.currentInterval = currentInterval;
    }

    public int incrementNoteBlockNumber() {
        ++this.noteBlockSearch;
        while (this.noteBlockSearch >= this.currentAdjacentNoteBlocks.size()) {
            this.noteBlockSearch -= this.currentAdjacentNoteBlocks.size();
        }
        return this.noteBlockSearch;
    }

    public boolean incrementInterval() {
        boolean marchControllerPattern = false;
        ++this.currentInterval;
        if (this.currentInterval >= 16) {
            this.currentInterval = 0;
            this.noteBlockSearch = 0;
            marchControllerPattern = true;
        }
        if (this.currentInterval == 0) {
            this.updatePendingPattern();
        }
        return marchControllerPattern;
    }

    public boolean verifyNoteBlockFacing(EnumFacing facing) {
        NoteBlockEvent.Instrument instrument;
        BlockPos offset = this.blockPos.func_177972_a(facing.func_176734_d());
        IBlockState noteBlockState = this.world.func_180495_p(offset);
        if (Blocks.field_150323_B.equals(noteBlockState.func_177230_c())) {
            IBlockState instrumentBlockState = this.world.func_180495_p(offset.func_177977_b());
            instrument = Sequencer.getInstrumentFromBlockState(instrumentBlockState);
        } else {
            instrument = null;
        }
        NoteBlockEvent.Instrument instrumentFromNoteBlock = this.getInstrumentFromNoteBlock(facing);
        if (instrument != instrumentFromNoteBlock) {
            this.setAdjacentNoteBlock(facing, instrument);
            return true;
        }
        return false;
    }

    private static NoteBlockEvent.Instrument getInstrumentFromBlockState(IBlockState state) {
        Material material = state.func_185904_a();
        if (material == Material.field_151576_e) {
            return NoteBlockEvent.Instrument.BASSDRUM;
        }
        if (material == Material.field_151595_p) {
            return NoteBlockEvent.Instrument.SNARE;
        }
        if (material == Material.field_151592_s) {
            return NoteBlockEvent.Instrument.CLICKS;
        }
        if (material == Material.field_151575_d) {
            return NoteBlockEvent.Instrument.BASSGUITAR;
        }
        Block block = state.func_177230_c();
        if (block == Blocks.field_150435_aG) {
            return NoteBlockEvent.Instrument.FLUTE;
        }
        if (block == Blocks.field_150340_R) {
            return NoteBlockEvent.Instrument.BELL;
        }
        if (block == Blocks.field_150325_L) {
            return NoteBlockEvent.Instrument.GUITAR;
        }
        if (block == Blocks.field_150403_cj) {
            return NoteBlockEvent.Instrument.CHIME;
        }
        if (block == Blocks.field_189880_di) {
            return NoteBlockEvent.Instrument.XYLOPHONE;
        }
        return NoteBlockEvent.Instrument.PIANO;
    }
}

