/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.sequencing;

import com.google.common.collect.ImmutableList;
import net.minecraft.block.BlockNote;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.atomicworkshop.jammachine.sequencing.AdjacentNoteBlock;
import org.atomicworkshop.jammachine.sequencing.Pattern;
import org.atomicworkshop.jammachine.sequencing.Sequencer;
import org.atomicworkshop.jammachine.sequencing.SequencerSet;

class PlayingSequence {
    private final SequencerSet sequencerSet;
    private long nextIntervalMilliseconds;

    PlayingSequence(SequencerSet sequencerSet) {
        this.sequencerSet = sequencerSet;
    }

    long getBeatsPerMinute() {
        return this.sequencerSet.getBeatsPerMinute();
    }

    long getNextIntervalMillis() {
        return this.nextIntervalMilliseconds;
    }

    void setNextIntervalMillis(long milliseconds) {
        this.nextIntervalMilliseconds = milliseconds;
    }

    void playNextInterval() {
        for (Sequencer sequencer : this.sequencerSet) {
            if (sequencer.incrementInterval()) {
                this.sequencerSet.marchInterval();
                int currentPatternIndexForSequencer = this.sequencerSet.getCurrentPatternIndexForSequencer(sequencer.getId());
                sequencer.setCurrentPatternIndex(currentPatternIndexForSequencer);
            }
            this.playSequencer(sequencer);
        }
    }

    private void playSequencer(Sequencer sequencer) {
        ImmutableList<AdjacentNoteBlock> availableNoteBlocks = sequencer.getAvailableNoteBlocks();
        if (availableNoteBlocks.isEmpty()) {
            return;
        }
        Pattern currentPattern = sequencer.getCurrentPattern();
        for (Byte pitchToPlay : currentPattern.getPitchesAtInterval(sequencer.getCurrentInterval())) {
            int noteBlockSearch = sequencer.incrementNoteBlockNumber();
            AdjacentNoteBlock noteBlock = (AdjacentNoteBlock)availableNoteBlocks.get(noteBlockSearch);
            this.playNote(sequencer, noteBlock, pitchToPlay);
        }
    }

    private void playNote(Sequencer sequencer, AdjacentNoteBlock noteBlock, Byte pitchToPlay) {
        BlockPos sequencerBlockPos = sequencer.getBlockPos();
        BlockPos pos = sequencerBlockPos.func_177972_a(noteBlock.getDirection());
        int instrumentId = noteBlock.getInstrument().ordinal();
        World world = sequencer.getWorld();
        NoteBlockEvent.Play e = new NoteBlockEvent.Play(world, pos, world.func_180495_p(pos), (int)pitchToPlay.byteValue(), instrumentId);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return;
        }
        int playingInstrumentId = e.getInstrument().ordinal();
        int playingNoteId = e.getVanillaNoteId();
        float pitch = (float)StrictMath.pow(2.0, (double)(playingNoteId - 12) / 12.0);
        SoundEvent instrument = PlayingSequence.getInstrument(playingInstrumentId);
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        world.func_184134_a(x, y, z, instrument, SoundCategory.RECORDS, 3.0f, pitch, false);
        world.func_175688_a(EnumParticleTypes.NOTE, x, y + 0.7, z, (double)playingNoteId / 24.0, 0.0, 0.0, new int[0]);
    }

    private static SoundEvent getInstrument(int eventId) {
        if (eventId < 0 || eventId >= BlockNote.field_176434_a.size()) {
            eventId = 0;
        }
        return (SoundEvent)BlockNote.field_176434_a.get(eventId);
    }

    SequencerSet getSequencerSet() {
        return this.sequencerSet;
    }
}

