/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.sequencing;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Pattern {
    private boolean[][] patternData = new boolean[16][25];

    public void setPitchAtInternal(int interval, int pitch) {
        if (pitch > 24) {
            pitch %= 25;
        }
        if (interval >= 16) {
            interval %= 16;
        }
        this.patternData[interval][pitch] = true;
    }

    public void resetPitchAtInterval(int interval, int pitch) {
        if (pitch > 24) {
            pitch %= 25;
        }
        if (interval >= 16) {
            interval %= 16;
        }
        this.patternData[interval][pitch] = false;
    }

    public boolean invertPitchAtInternal(int interval, int pitch) {
        boolean newValue;
        while (pitch > 24) {
            pitch -= 25;
        }
        while (interval >= 16) {
            interval -= 16;
        }
        this.patternData[interval][pitch] = newValue = !this.patternData[interval][pitch];
        return newValue;
    }

    public Iterable<Byte> getPitchesAtInterval(int interval) {
        return () -> new PitchIterator(this.patternData[interval]);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean[] getRawPatternData(int interval) {
        return this.patternData[interval];
    }

    private static class PitchIterator
    implements Iterator<Byte> {
        private byte currentPitch;
        private final boolean[] enabledPitches;

        public PitchIterator(boolean[] enabledPitches) {
            this.enabledPitches = enabledPitches;
            this.currentPitch = (byte)-1;
        }

        @Override
        public boolean hasNext() {
            this.currentPitch = (byte)(this.currentPitch + 1);
            while (this.currentPitch < this.enabledPitches.length) {
                if (this.enabledPitches[this.currentPitch]) {
                    return true;
                }
                this.currentPitch = (byte)(this.currentPitch + 1);
            }
            return false;
        }

        @Override
        public Byte next() {
            if (this.currentPitch >= this.enabledPitches.length) {
                throw new NoSuchElementException();
            }
            return this.currentPitch;
        }
    }
}

