/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.sequencing;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.atomicworkshop.jammachine.sequencing.JamController;
import org.atomicworkshop.jammachine.sequencing.PlayingSequence;
import org.atomicworkshop.jammachine.sequencing.Sequencer;
import org.atomicworkshop.jammachine.sequencing.SequencerSet;

@Mod.EventBusSubscriber
public final class MusicPlayer {
    private static final List<PlayingSequence> playingSequences = Lists.newArrayList();
    private static final Object sequenceLock = new Object();
    private static long lastUpdateIndex = Long.MIN_VALUE;
    private static final List<Sequencer> trackedSequencers = Lists.newArrayList();
    private static final List<JamController> trackedControllers = Lists.newArrayList();
    private static final Object trackingLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void playSong(SequencerSet sequencerSet) {
        if (sequencerSet == null) {
            return;
        }
        sequencerSet.updateBpm();
        if (sequencerSet.getBeatsPerMinute() == 0) {
            return;
        }
        long currentTimeMillis = System.nanoTime() / 1000000L;
        Object object = sequenceLock;
        synchronized (object) {
            for (PlayingSequence playingSequence : playingSequences) {
                if (!playingSequence.getSequencerSet().getId().equals(sequencerSet.getId())) continue;
                return;
            }
            PlayingSequence e = new PlayingSequence(sequencerSet);
            e.setNextIntervalMillis(currentTimeMillis + 250L / (e.getBeatsPerMinute() / 60L));
            for (Sequencer sequencer : sequencerSet) {
                sequencer.setCurrentInterval(0);
                sequencer.setCurrentPatternIndex(sequencer.getPendingPatternIndex());
            }
            playingSequences.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopPlaying(UUID sequencerSetId) {
        if (sequencerSetId == null) {
            return;
        }
        Object object = sequenceLock;
        synchronized (object) {
            playingSequences.removeIf(playingSequence -> playingSequence.getSequencerSet().getId().equals(sequencerSetId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.func_147113_T()) {
            return;
        }
        if (minecraft.field_71441_e == null) {
            Object object = sequenceLock;
            synchronized (object) {
                playingSequences.clear();
            }
            return;
        }
        long currentTimeMillis = System.nanoTime() / 1000000L;
        Object object = sequenceLock;
        synchronized (object) {
            if (playingSequences.isEmpty()) {
                return;
            }
            for (PlayingSequence playingSequence : playingSequences) {
                long nextIntervalMillis;
                if (playingSequence.getSequencerSet().getBeatsPerMinute() == 0 || currentTimeMillis < (nextIntervalMillis = playingSequence.getNextIntervalMillis())) continue;
                long millisToNextInterval = 250L / (playingSequence.getBeatsPerMinute() / 60L);
                playingSequence.setNextIntervalMillis(currentTimeMillis + millisToNextInterval);
                playingSequence.playNextInterval();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopTrackingSequencerAt(World worldIn, BlockPos pos) {
        Object object = trackingLock;
        synchronized (object) {
            ++lastUpdateIndex;
            trackedSequencers.removeIf(sequencer -> sequencer.getWorld().field_73011_w.getDimension() == worldIn.field_73011_w.getDimension() && pos.equals((Object)sequencer.getBlockPos()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopTrackingControllerAt(World worldIn, BlockPos pos) {
        Object object = trackingLock;
        synchronized (object) {
            ++lastUpdateIndex;
            trackedControllers.removeIf(controller -> controller.getWorld().field_73011_w.getDimension() == worldIn.field_73011_w.getDimension() && pos.equals((Object)controller.getPos()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startTracking(JamController controller) {
        Object object = trackingLock;
        synchronized (object) {
            ++lastUpdateIndex;
            for (JamController trackedController : trackedControllers) {
                if (!trackedController.getId().equals(controller.getId())) continue;
                return;
            }
            trackedControllers.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startTracking(Sequencer sequencer) {
        Object object = trackingLock;
        synchronized (object) {
            ++lastUpdateIndex;
            for (Sequencer trackedSequencer : trackedSequencers) {
                if (!trackedSequencer.getId().equals(sequencer.getId())) continue;
                return;
            }
            trackedSequencers.add(sequencer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequencer getSequencerById(UUID sequencerId) {
        Object object = trackingLock;
        synchronized (object) {
            for (Sequencer trackedSequencer : trackedSequencers) {
                if (!trackedSequencer.getId().equals(sequencerId)) continue;
                return trackedSequencer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastUpdateIndex() {
        Object object = trackingLock;
        synchronized (object) {
            return lastUpdateIndex;
        }
    }
}

