/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.sequencing;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.atomicworkshop.jammachine.JamMachineMod;
import org.atomicworkshop.jammachine.sequencing.ControllerPattern;
import org.atomicworkshop.jammachine.sequencing.MusicPlayer;
import org.atomicworkshop.jammachine.sequencing.Sequencer;
import org.atomicworkshop.jammachine.sequencing.SequencerSet;

public class JamController
extends SequencerSet {
    private final World world;
    private final BlockPos pos;
    private final List<ControllerPattern> sequencerPatternSections = Lists.newArrayList();
    private int currentInterval = 0;
    private long lastUpdateIndex = Long.MIN_VALUE;

    public JamController(World world, BlockPos pos) {
        super(UUID.randomUUID());
        this.world = world;
        this.pos = pos;
    }

    @Override
    public void addSequencer(Sequencer sequencer) {
        if (sequencer.getWorld().field_73011_w.getDimension() != this.world.field_73011_w.getDimension()) {
            JamMachineMod.logger.warn("SequencerSet world {} vs Sequencer world {}", (Object)this.world.field_73011_w.getDimension(), (Object)sequencer.getWorld().field_73011_w.getDimension());
        }
        super.addSequencer(sequencer);
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void marchInterval() {
        ++this.currentInterval;
    }

    @Override
    public int getCurrentPatternIndexForSequencer(UUID id) {
        for (ControllerPattern section : this.sequencerPatternSections) {
            if (!section.getSequencerId().equals(id)) continue;
            return section.getPatternAtInterval(this.currentInterval);
        }
        return 0;
    }

    public void findSequencers() {
        if (this.lastUpdateIndex == MusicPlayer.getLastUpdateIndex()) {
            return;
        }
        this.lastUpdateIndex = MusicPlayer.getLastUpdateIndex();
        for (ControllerPattern sequencerPatternSection : this.sequencerPatternSections) {
            Sequencer sequencer;
            if (sequencerPatternSection.locatedSequencer != null || (sequencer = MusicPlayer.getSequencerById(sequencerPatternSection.sequencerId)) == null) continue;
            sequencerPatternSection.locatedSequencer = sequencer;
        }
    }

    public ControllerPattern getControllerPatternForId(UUID id) {
        for (ControllerPattern sequencerPatternSection : this.sequencerPatternSections) {
            if (!sequencerPatternSection.isForLoadedSequencer(id)) continue;
            return sequencerPatternSection;
        }
        return null;
    }
}

