/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.handlers;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.atomicworkshop.jammachine.Reference;
import org.atomicworkshop.jammachine.blocks.BlockSequencer;
import org.atomicworkshop.jammachine.items.ItemPunchCardBlank;
import org.atomicworkshop.jammachine.items.ItemPunchCardWritten;
import org.atomicworkshop.jammachine.libraries.BlockLibrary;
import org.atomicworkshop.jammachine.tiles.TileEntitySequencer;

@Mod.EventBusSubscriber
public final class RegistrationHandler {
    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> registryEvent) {
        IForgeRegistry registry = registryEvent.getRegistry();
        RegistrationHandler.registerBlock((IForgeRegistry<Block>)registry, (Block)new BlockSequencer(), Reference.Blocks.sequencer);
        GameRegistry.registerTileEntity(TileEntitySequencer.class, (String)Reference.TileEntities.sequencer);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> registryEvent) {
        IForgeRegistry registry = registryEvent.getRegistry();
        RegistrationHandler.registerItemFromBlock((IForgeRegistry<Item>)registry, (Block)BlockLibrary.sequencer);
        RegistrationHandler.registerItem((IForgeRegistry<Item>)registry, new ItemPunchCardBlank(), Reference.Items.punchcardblank, true);
        RegistrationHandler.registerItem((IForgeRegistry<Item>)registry, new ItemPunchCardWritten(), Reference.Items.punchcardwritten, false);
    }

    private static void registerBlock(IForgeRegistry<Block> registry, Block block, ResourceLocation registryName) {
        registry.register((IForgeRegistryEntry)((Block)block.setRegistryName(registryName)).func_149647_a(Reference.CreativeTab).func_149663_c(registryName.toString()));
    }

    private static void registerItem(IForgeRegistry<Item> registry, Item item, ResourceLocation registryName, boolean showInCreativeTab) {
        ((Item)item.setRegistryName(registryName)).func_77655_b(registryName.toString());
        if (showInCreativeTab) {
            item.func_77637_a(Reference.CreativeTab);
        }
        registry.register((IForgeRegistryEntry)item);
    }

    private static void registerItemFromBlock(IForgeRegistry<Item> registry, Block block) {
        ResourceLocation registryName = block.getRegistryName();
        assert (registryName != null);
        registry.register((IForgeRegistryEntry)((Item)new ItemBlock(block).setRegistryName(registryName)).func_77655_b(registryName.toString()));
    }
}

