/*
 * Decompiled with CFR 0.152.
 */
package org.atomicworkshop.jammachine.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.atomicworkshop.jammachine.JamMachineMod;
import org.atomicworkshop.jammachine.blocks.MachineMaterial;
import org.atomicworkshop.jammachine.sequencing.MusicPlayer;
import org.atomicworkshop.jammachine.tiles.TileEntityController;
import org.atomicworkshop.jammachine.tiles.TileEntitySequencer;

public class BlockController
extends Block
implements ITileEntityProvider {
    private final AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockController() {
        super((Material)new MachineMaterial());
        IBlockState defaultState = this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH);
        this.func_180632_j(defaultState);
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBox;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityController();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityController teSequencer = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (teSequencer != null) {
            teSequencer.stopPlaying();
            MusicPlayer.stopTrackingControllerAt(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing value;
        boolean isPowered = false;
        EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
        int n = enumFacingArray.length;
        for (int i = 0; i < n && !(isPowered = worldIn.func_175640_z(pos.func_177972_a(value = enumFacingArray[i]))); ++i) {
        }
        TileEntityController tileEntity = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tileEntity == null) {
            return;
        }
        tileEntity.notifyPowered(isPowered);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        TileEntityController tileEntity = this.getTileEntity((IBlockAccess)world, pos);
        if (tileEntity == null) {
            return false;
        }
        return tileEntity.func_145842_c(id, param);
    }

    @Nullable
    private TileEntityController getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySequencer) {
            return (TileEntityController)tileEntity;
        }
        JamMachineMod.logger.error("No Tile entity found at block location? {}", (Object)pos);
        return null;
    }
}

