/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.bithop.util;

import com.elytradev.bithop.util.IConfigSerializable;
import com.google.common.base.Joiner;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigKey<T> {
    protected final String category;
    protected final String key;
    protected final Property.Type type;
    protected final String description;
    protected final T defaultValue;

    protected ConfigKey(String category, String key, Property.Type type, T defaultValue, String ... description) {
        this.category = category;
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
        this.description = Joiner.on((char)'\n').join((Object[])description);
    }

    public void set(Configuration config, T value) {
        this.getProperty(config).set(value.toString());
    }

    public T get(Configuration config) {
        switch (this.type) {
            case BOOLEAN: {
                return (T)Boolean.valueOf(this.getProperty(config).getBoolean());
            }
            case DOUBLE: {
                return (T)Double.valueOf(this.getProperty(config).getDouble());
            }
            case INTEGER: {
                return (T)Integer.valueOf(this.getProperty(config).getInt());
            }
            case STRING: {
                return (T)this.getProperty(config).getString();
            }
        }
        return null;
    }

    protected Property getProperty(Configuration config) {
        return config.get(this.category, this.key, this.defaultValue.toString(), this.description, this.type);
    }

    public static ConfigKey<Boolean> create(String category, String key, boolean defaultValue, String ... description) {
        return new ConfigKey<Boolean>(category, key, Property.Type.BOOLEAN, defaultValue, description);
    }

    public static ConfigKey<Integer> create(String category, String key, int defaultValue, String ... description) {
        return new ConfigKey<Integer>(category, key, Property.Type.INTEGER, defaultValue, description);
    }

    public static ConfigKey<Double> create(String category, String key, double defaultValue, String ... description) {
        return new ConfigKey<Double>(category, key, Property.Type.DOUBLE, defaultValue, description);
    }

    public static <T extends Enum<T>> ConfigKey<T> create(String category, String key, T defaultValue, String ... description) {
        return new ConfigKey<T>(category, key, Property.Type.STRING, defaultValue, description){

            @Override
            public T get(Configuration config) {
                String str = this.getProperty(config).getString();
                for (Enum t : (Enum[])((Enum)this.defaultValue).getClass().getEnumConstants()) {
                    if (!((IConfigSerializable)((Object)t)).matches(str)) continue;
                    return t;
                }
                return null;
            }

            @Override
            public void set(Configuration config, T value) {
                this.getProperty(config).set(((IConfigSerializable)value).toConfigString());
            }
        };
    }
}

