/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.bithop.repackage.com.elytradev.concrete.recipe.impl;

import com.elytradev.bithop.repackage.com.elytradev.concrete.recipe.ItemIngredient;
import com.elytradev.bithop.repackage.com.elytradev.concrete.recipe.impl.InventoryGridRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class ShapelessInventoryRecipe
extends InventoryGridRecipe {
    private List<ItemIngredient> input = new ArrayList<ItemIngredient>();
    private ItemStack output;
    private ResourceLocation registryName;

    public ShapelessInventoryRecipe(ItemStack output, ItemIngredient ... ingredients) {
        for (ItemIngredient item : ingredients) {
            this.input.add(item);
        }
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public boolean matches(IItemHandler handler) {
        ArrayList<ItemIngredient> toFind = new ArrayList<ItemIngredient>(this.input);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            ItemIngredient found = null;
            for (ItemIngredient ingredient : toFind) {
                if (!ingredient.apply(stack)) continue;
                found = ingredient;
                break;
            }
            if (found == null) {
                return false;
            }
            toFind.remove(found);
        }
        return toFind.isEmpty();
    }

    @Override
    public boolean matches(IInventory inventory) {
        ArrayList<ItemIngredient> toFind = new ArrayList<ItemIngredient>(this.input);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            ItemIngredient found = null;
            for (ItemIngredient ingredient : toFind) {
                if (!ingredient.apply(stack)) continue;
                found = ingredient;
                break;
            }
            if (found == null) {
                return false;
            }
            toFind.remove(found);
        }
        return toFind.isEmpty();
    }

    @Override
    public boolean consumeIngredients(IItemHandler inventory, boolean doConsume) {
        ArrayList<ItemIngredient> toFind = new ArrayList<ItemIngredient>(this.input);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            ItemIngredient found = null;
            for (ItemIngredient ingredient : toFind) {
                if (!ingredient.apply(stack)) continue;
                found = ingredient;
                if (!inventory.extractItem(i, 1, !doConsume).func_190926_b()) break;
                found = null;
            }
            if (found == null) continue;
            toFind.remove(found);
        }
        return toFind.isEmpty();
    }

    @Override
    public boolean consumeIngredients(IInventory inventory, boolean doConsume) {
        ArrayList<ItemIngredient> toFind = new ArrayList<ItemIngredient>(this.input);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            ItemIngredient found = null;
            for (ItemIngredient ingredient : toFind) {
                if (!ingredient.apply(stack)) continue;
                found = ingredient;
                if (!doConsume) continue;
                inventory.func_70298_a(i, 1);
            }
            if (found == null) continue;
            toFind.remove(found);
        }
        return toFind.isEmpty();
    }

    public InventoryGridRecipe setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Class<InventoryGridRecipe> getRegistryType() {
        return InventoryGridRecipe.class;
    }
}

