/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.bithop.repackage.com.elytradev.concrete.recipe.impl;

import com.elytradev.bithop.repackage.com.elytradev.concrete.recipe.ItemIngredient;
import com.elytradev.bithop.repackage.com.elytradev.concrete.recipe.impl.InventoryGridRecipe;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Arrays;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class ShapedInventoryRecipe
extends InventoryGridRecipe {
    protected ItemStack result;
    protected int gridWidth = 1;
    protected int gridHeight = 1;
    protected ItemIngredient[] recipe;
    protected ItemIngredient[] flipped = null;
    protected ResourceLocation registryName;

    public ShapedInventoryRecipe(ItemStack result, int gridWidth, int gridHeight, int recipeWidth, int recipeHeight, boolean alsoFlipped, ItemIngredient ... recipe) {
        this.result = result;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.recipe = new ItemIngredient[gridWidth * gridHeight];
        for (int y = 0; y < gridHeight; ++y) {
            for (int x = 0; x < gridWidth; ++x) {
                int index = y * gridWidth + x;
                int recipeIndex = y * recipeWidth + x;
                if (x >= recipeWidth || y >= recipeHeight || recipeIndex >= recipe.length) continue;
                this.recipe[index] = recipe[recipeIndex];
            }
        }
        this.recipe = ShapedInventoryRecipe.snug(this.recipe, gridWidth, gridHeight, it -> false);
        if (alsoFlipped) {
            this.flipped = ShapedInventoryRecipe.snug(ShapedInventoryRecipe.flip(this.recipe, gridWidth, gridHeight), gridWidth, gridHeight, it -> false);
        }
    }

    public ShapedInventoryRecipe(ItemStack result, int width, int height, ItemIngredient item) {
        this(result, width, height, 1, 1, false, item);
    }

    public static <T> T[] snug(T[] ts, int wid, int hit, Predicate<T> isEmpty) {
        int x;
        int y;
        T[] result = Arrays.copyOf(ts, ts.length);
        int minX = wid;
        int minY = hit;
        for (y = 0; y < hit; ++y) {
            for (x = 0; x < wid; ++x) {
                T t;
                int index = y * wid + x;
                if (index >= ts.length || (t = ts[index]) == null || isEmpty.apply(t)) continue;
                minX = Math.min(minX, x);
                minY = Math.min(minY, y);
            }
        }
        for (y = 0; y < hit; ++y) {
            for (x = 0; x < wid; ++x) {
                T t;
                int srci = (y + minY) * wid + (x + minX);
                int dsti = y * wid + x;
                if (dsti >= result.length) continue;
                result[dsti] = srci >= ts.length ? null : ((t = ts[srci]) == null || isEmpty.apply(t) ? null : ts[srci]);
            }
        }
        return result;
    }

    public static <T> T[] flip(T[] ts, int wid, int hit) {
        T[] result = Arrays.copyOf(ts, ts.length);
        for (int y = 0; y < hit; ++y) {
            for (int x = 0; x < wid; ++x) {
                int dest = y * wid + x;
                int src = y * wid + (-x + (wid - 1));
                result[dest] = ts[src];
            }
        }
        return result;
    }

    @Override
    public boolean matches(IItemHandler inventory) {
        Vec2i translation = this.findTranslation(inventory.getSlots(), arg_0 -> ((IItemHandler)inventory).getStackInSlot(arg_0), ItemStack::func_190926_b);
        if (translation.x >= this.gridWidth || translation.y >= this.gridHeight) {
            return false;
        }
        if (this.apply(this.recipe, inventory.getSlots(), translation.x, translation.y, (Function<Integer, ItemStack>)((Function)arg_0 -> ((IItemHandler)inventory).getStackInSlot(arg_0)), (Function<Integer, ItemStack>)((Function)it -> inventory.extractItem(it.intValue(), 1, true)), false)) {
            return true;
        }
        if (this.flipped != null) {
            if (this.apply(this.flipped, inventory.getSlots(), translation.x, translation.y, (Function<Integer, ItemStack>)((Function)arg_0 -> ((IItemHandler)inventory).getStackInSlot(arg_0)), (Function<Integer, ItemStack>)((Function)it -> inventory.extractItem(it.intValue(), 1, true)), false)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matches(IInventory inventory) {
        Vec2i translation = this.findTranslation(inventory.func_70302_i_(), arg_0 -> ((IInventory)inventory).func_70301_a(arg_0), ItemStack::func_190926_b);
        if (translation.x >= this.gridWidth || translation.y >= this.gridHeight) {
            return false;
        }
        if (this.apply(this.recipe, inventory.func_70302_i_(), translation.x, translation.y, (Function<Integer, ItemStack>)((Function)arg_0 -> ((IInventory)inventory).func_70301_a(arg_0)), (Function<Integer, ItemStack>)((Function)it -> inventory.func_70298_a(it.intValue(), 1)), false)) {
            return true;
        }
        if (this.flipped != null) {
            if (this.apply(this.flipped, inventory.func_70302_i_(), translation.x, translation.y, (Function<Integer, ItemStack>)((Function)arg_0 -> ((IInventory)inventory).func_70301_a(arg_0)), (Function<Integer, ItemStack>)((Function)it -> inventory.func_70298_a(it.intValue(), 1)), false)) {
                return true;
            }
        }
        return false;
    }

    protected boolean apply(ItemIngredient[] ingredients, int numSlots, int translateX, int translateY, Function<Integer, ItemStack> slotInspector, Function<Integer, ItemStack> slotExtractor, boolean doConsume) {
        if (doConsume && !this.apply(ingredients, numSlots, translateX, translateY, slotInspector, slotExtractor, false)) {
            return false;
        }
        if (numSlots < ingredients.length) {
            return false;
        }
        for (int y = 0; y < this.gridHeight; ++y) {
            for (int x = 0; x < this.gridWidth; ++x) {
                ItemStack extracted;
                ItemStack stack;
                int srcIndex = y * this.gridWidth + x;
                int destIndex = (y + translateY) * this.gridWidth + (x + translateX);
                if (destIndex >= numSlots || srcIndex >= ingredients.length) continue;
                if (ingredients[srcIndex] == null) {
                    stack = (ItemStack)slotInspector.apply((Object)destIndex);
                    if (stack == null || stack.func_190926_b()) continue;
                    return false;
                }
                stack = (ItemStack)slotInspector.apply((Object)destIndex);
                if (!ingredients[srcIndex].apply(stack)) {
                    return false;
                }
                if (!doConsume || (extracted = (ItemStack)slotExtractor.apply((Object)destIndex)) != null && !extracted.func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    protected <T> Vec2i findTranslation(int numSlots, Function<Integer, T> slotInspector, Predicate<T> isEmpty) {
        Vec2i result = new Vec2i(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (int y = 0; y < this.gridHeight; ++y) {
            for (int x = 0; x < this.gridWidth; ++x) {
                Object t;
                int index = y * this.gridWidth + x;
                if (index >= numSlots || (t = slotInspector.apply((Object)index)) == null || isEmpty.apply(t)) continue;
                result.x = Math.min(result.x, x);
                result.y = Math.min(result.y, y);
            }
        }
        return result;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    @Override
    public ItemStack getOutput() {
        return this.result;
    }

    @Override
    public boolean consumeIngredients(IItemHandler inventory, boolean doConsume) {
        Vec2i translation = this.findTranslation(inventory.getSlots(), arg_0 -> ((IItemHandler)inventory).getStackInSlot(arg_0), ItemStack::func_190926_b);
        return this.apply(this.recipe, inventory.getSlots(), translation.x, translation.y, (Function<Integer, ItemStack>)((Function)arg_0 -> ((IItemHandler)inventory).getStackInSlot(arg_0)), (Function<Integer, ItemStack>)((Function)it -> inventory.extractItem(it.intValue(), 1, !doConsume)), doConsume);
    }

    @Override
    public boolean consumeIngredients(IInventory inventory, boolean doConsume) {
        Vec2i translation = this.findTranslation(inventory.func_70302_i_(), arg_0 -> ((IInventory)inventory).func_70301_a(arg_0), ItemStack::func_190926_b);
        return this.apply(this.recipe, inventory.func_70302_i_(), translation.x, translation.y, (Function<Integer, ItemStack>)((Function)arg_0 -> ((IInventory)inventory).func_70301_a(arg_0)), (Function<Integer, ItemStack>)((Function)it -> inventory.func_70298_a(it.intValue(), 1)), doConsume);
    }

    public InventoryGridRecipe setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public Class<InventoryGridRecipe> getRegistryType() {
        return InventoryGridRecipe.class;
    }

    private static class Vec2i {
        public int x;
        public int y;

        public Vec2i() {
            this(0, 0);
        }

        public Vec2i(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "{x:" + this.x + ", y:" + this.y + "}";
        }
    }
}

