/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.bithop.repackage.com.elytradev.concrete.recipe.impl;

import com.elytradev.bithop.repackage.com.elytradev.concrete.recipe.FluidIngredient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackIngredient
extends FluidIngredient {
    private FluidStack stack;

    public FluidStackIngredient(FluidStack stack) {
        this.stack = stack;
    }

    public boolean apply(FluidStack input) {
        if (input == null || this.stack == null) {
            return false;
        }
        return input.containsFluid(this.stack);
    }

    public boolean equals(Object other) {
        if (!(other instanceof FluidStackIngredient)) {
            return false;
        }
        FluidStack b = ((FluidStackIngredient)other).stack;
        if (b.tag == null ^ this.stack.tag == null) {
            return false;
        }
        return b.getFluid() == this.stack.getFluid() && b.amount == this.stack.amount && (b.tag == null || b.tag.equals((Object)this.stack.tag));
    }

    public int hashCode() {
        int result = FluidRegistry.getFluidName((Fluid)this.stack.getFluid()).hashCode();
        result *= 31;
        result ^= Integer.hashCode(this.stack.amount);
        if (this.stack.tag != null) {
            result *= 31;
            result ^= this.stack.tag.hashCode();
        }
        return result;
    }

    @Override
    public int getAmount() {
        return this.stack == null ? 0 : this.stack.amount;
    }
}

