/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.bithop.repackage.com.elytradev.concrete.inventory.gui.widget;

import com.elytradev.bithop.repackage.com.elytradev.concrete.inventory.gui.ConcreteContainer;
import com.elytradev.bithop.repackage.com.elytradev.concrete.inventory.gui.widget.WWidget;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WPanel
extends WWidget {
    protected final List<WWidget> children = Lists.newArrayList();
    protected boolean valid;

    @Override
    public void createPeers(ConcreteContainer c) {
        for (WWidget child : this.children) {
            child.createPeers(c);
        }
        this.valid = true;
    }

    public void remove(WWidget w) {
        this.children.remove(w);
        this.valid = false;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    public void layout() {
        for (WWidget child : this.children) {
            if (child instanceof WPanel) {
                ((WPanel)child).layout();
            }
            this.expandToFit(child);
        }
    }

    protected void expandToFit(WWidget w) {
        int pushRight = w.getX() + w.getWidth();
        int pushDown = w.getY() + w.getHeight();
        this.setSize(Math.max(this.getWidth(), pushRight), Math.max(this.getHeight(), pushDown));
    }

    @Override
    public WWidget onMouseUp(int x, int y, int button) {
        if (this.children.isEmpty()) {
            return super.onMouseUp(x, y, button);
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            WWidget child = this.children.get(i);
            if (x < child.getX() || y < child.getY() || x >= child.getX() + child.getWidth() || y >= child.getY() + child.getHeight()) continue;
            return child.onMouseUp(x - child.getX(), y - child.getY(), button);
        }
        return super.onMouseUp(x, y, button);
    }

    @Override
    public WWidget onMouseDown(int x, int y, int button) {
        if (this.children.isEmpty()) {
            return super.onMouseDown(x, y, button);
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            WWidget child = this.children.get(i);
            if (x < child.getX() || y < child.getY() || x >= child.getX() + child.getWidth() || y >= child.getY() + child.getHeight()) continue;
            return child.onMouseDown(x - child.getX(), y - child.getY(), button);
        }
        return super.onMouseDown(x, y, button);
    }

    @Override
    public void onMouseDrag(int x, int y, int button) {
        if (this.children.isEmpty()) {
            return;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            WWidget child = this.children.get(i);
            if (x < child.getX() || y < child.getY() || x >= child.getX() + child.getWidth() || y >= child.getY() + child.getHeight()) continue;
            child.onMouseDrag(x - child.getX(), y - child.getY(), button);
            return;
        }
        super.onMouseDrag(x, y, button);
    }

    @Override
    public void onClick(int x, int y, int button) {
        if (this.children.isEmpty()) {
            return;
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            WWidget child = this.children.get(i);
            if (x < child.getX() || y < child.getY() || x >= child.getX() + child.getWidth() || y >= child.getY() + child.getHeight()) continue;
            child.onClick(x - child.getX(), y - child.getY(), button);
            return;
        }
    }

    @Override
    public void validate(ConcreteContainer c) {
        this.layout();
        this.createPeers(c);
        this.valid = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void paintBackground(int x, int y) {
        for (WWidget child : this.children) {
            child.paintBackground(x + child.getX(), y + child.getY());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void paintForeground(int x, int y, int mouseX, int mouseY) {
        for (WWidget child : this.children) {
            child.paintForeground(x + child.getX(), y + child.getY(), mouseX, mouseY);
        }
    }
}

