/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.bithop.repackage.com.elytradev.concrete.common;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Either<L, R> {
    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public Optional<L> getLeft() {
        return Optional.ofNullable(this.getLeftNullable());
    }

    public Optional<R> getRight() {
        return Optional.ofNullable(this.getRightNullable());
    }

    @Nullable
    public L getLeftNullable() {
        return null;
    }

    @Nullable
    public R getRightNullable() {
        return null;
    }

    public abstract boolean isLeft();

    public boolean isRight() {
        return !this.isLeft();
    }

    public final <T> T map(Function<? super L, ? extends T> lFunc, Function<? super R, ? extends T> rFunc) {
        return this.isLeft() ? lFunc.apply(this.getLeftNullable()) : rFunc.apply(this.getRightNullable());
    }

    public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> lFunc) {
        if (this.isLeft()) {
            return new Left(lFunc.apply(this.getLeftNullable()));
        }
        return new Right(this.getRightNullable());
    }

    public <T> Either<L, T> mapRight(Function<? super R, ? extends T> rFunc) {
        if (this.isLeft()) {
            return new Left(this.getLeftNullable());
        }
        return new Right(rFunc.apply(this.getRightNullable()));
    }

    public void apply(Consumer<? super L> lFunc, Consumer<? super R> rFunc) {
        if (this.isLeft()) {
            lFunc.accept(this.getLeftNullable());
        } else {
            rFunc.accept(this.getRightNullable());
        }
    }

    static class Right<L, R>
    extends Either<L, R> {
        R val;

        public Right(@Nonnull R val) {
            this.val = val;
        }

        @Override
        public R getRightNullable() {
            return this.val;
        }

        @Override
        public boolean isLeft() {
            return false;
        }
    }

    static class Left<L, R>
    extends Either<L, R> {
        L val;

        public Left(@Nonnull L val) {
            this.val = val;
        }

        @Override
        public L getLeftNullable() {
            return this.val;
        }

        @Override
        public boolean isLeft() {
            return true;
        }
    }
}

