/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.bithop.repackage.com.elytradev.concrete.common;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ConcreteToast
implements IToast {
    private ResourceLocation texture;
    private String title;
    private String subtitle;
    private long timing;
    private int titleColor;
    private int subtitleColor;
    private int textureX;
    private int textureY;

    private ConcreteToast(@Nonnull String title, @Nullable String subtitle, long timing, @Nonnull String texture, int titleColor, int subtitleColor, int textureX, int textureY) {
        this.title = title;
        this.subtitle = subtitle;
        this.timing = timing;
        this.texture = new ResourceLocation(texture);
        this.titleColor = titleColor;
        this.subtitleColor = subtitleColor;
        this.textureX = textureX;
        this.textureY = textureY;
    }

    public static Builder builder(String title) {
        return new Builder(title);
    }

    @Nonnull
    public IToast.Visibility func_193653_a(@Nonnull GuiToast toastGui, long delta) {
        toastGui.func_192989_b().func_110434_K().func_110577_a(this.texture);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        toastGui.func_73729_b(0, 0, this.textureX, this.textureY, 160, 32);
        if (this.subtitle == null) {
            toastGui.func_192989_b().field_71466_p.func_78276_b(this.title, 30, 12, this.titleColor);
        } else {
            toastGui.func_192989_b().field_71466_p.func_78276_b(this.title, 30, 7, this.titleColor);
            toastGui.func_192989_b().field_71466_p.func_78276_b(this.subtitle, 30, 18, this.subtitleColor);
        }
        return delta < this.timing ? IToast.Visibility.SHOW : IToast.Visibility.HIDE;
    }

    public static class Builder {
        private String title;
        private String subtitle;
        private long timing = 5000L;
        private String texture = "textures/gui/toasts.png";
        private int titleColor = -256;
        private int subtitleColor = -1;
        private int textureX = 0;
        private int textureY = 96;

        private Builder(String title) {
            this.title = title;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setSubtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder setTiming(long timing) {
            this.timing = timing;
            return this;
        }

        public Builder setTexture(String texture) {
            this.texture = texture;
            return this;
        }

        public Builder setTitleColor(int titleColor) {
            this.titleColor = titleColor;
            return this;
        }

        public Builder setSubtitleColor(int subtitleColor) {
            this.subtitleColor = subtitleColor;
            return this;
        }

        public Builder setTextureX(int textureX) {
            this.textureX = textureX;
            return this;
        }

        public Builder setTextureY(int textureY) {
            this.textureY = textureY;
            return this;
        }

        public ConcreteToast create() {
            return new ConcreteToast(this.title, this.subtitle, this.timing, this.texture, this.titleColor, this.subtitleColor, this.textureX, this.textureY);
        }
    }
}

