/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.IPackReaderCallback;
import com.mia.craftstudio.api.ICSProject;
import com.mia.craftstudio.minecraft.forge.CSLibMod;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ProgressManager;
import team.thegoldenhoe.cameraobscura.CSModelMetadata;
import team.thegoldenhoe.cameraobscura.CameraObscura;

public class ModelHandler {
    public static ICSProject csproject;
    public static Map<Integer, CSModelMetadata> modelData;

    public static void loadModels() {
        csproject = CSLibMod.getCSProjectAndLoad((String)"cspack", null, (IPackReaderCallback)new IPackReaderCallback(){
            private ProgressManager.ProgressBar progressBar = null;

            public void modelLoaded(CSModel model, JsonElement json) {
                if (json != null) {
                    this.progressBar.step(json.getAsJsonObject().get("name").getAsString());
                }
                if (this.progressBar.getStep() == this.progressBar.getSteps()) {
                    ProgressManager.pop((ProgressManager.ProgressBar)this.progressBar);
                }
            }

            public void setCount(int count) {
                this.progressBar = ProgressManager.push((String)"Loading models", (int)count);
            }
        });
        Gson gson = new GsonBuilder().create();
        for (Map.Entry entry : csproject.getModels().entrySet()) {
            JsonElement modelDescriptor = csproject.getDescriptor((Integer)entry.getKey());
            if (modelDescriptor == null) continue;
            ModelHandler.validateModelMetadata((CSModelMetadata)((Object)gson.fromJson(modelDescriptor, CSModelMetadata.class)), (CSModel)entry.getValue());
        }
        CameraObscura.proxy.setupModelWrappers();
    }

    private static void validateModelMetadata(CSModelMetadata metaData, CSModel model) {
        if (modelData.containsKey(metaData.decocraftModelID)) {
            CSModelMetadata existingMeta = modelData.get(metaData.decocraftModelID);
            if (!existingMeta.craftstudioAssetName.equals(metaData.craftstudioAssetName)) {
                throw new RuntimeException("You gave a new model the same DecoID as an existing model! Existing:[" + existingMeta.craftstudioAssetName + "], New:[" + metaData.craftstudioAssetName + "]");
            }
        }
        metaData.csmodel = model;
        metaData.validate();
        modelData.put(metaData.decocraftModelID, metaData);
    }

    public static TileEntity getTileEntityPreferNotCreating(IBlockAccess blockAccess, BlockPos pos) {
        if (blockAccess instanceof World) {
            return ModelHandler.getTileEntityWithoutCreating((World)blockAccess, pos);
        }
        if (blockAccess instanceof ChunkCache) {
            return ModelHandler.getTileEntityWithoutCreating(((ChunkCache)blockAccess).field_72815_e, pos);
        }
        return blockAccess.func_175625_s(pos);
    }

    public static TileEntity getTileEntityWithoutCreating(World world, BlockPos pos) {
        if (world.func_175668_a(pos, false)) {
            return ModelHandler.getTileEntityUnsafe(pos, world.func_175726_f(pos).func_177434_r());
        }
        return null;
    }

    private static TileEntity getTileEntityUnsafe(BlockPos pos, Map<BlockPos, TileEntity> tileMap) {
        TileEntity tileentity = tileMap.get(pos);
        if (tileentity != null && tileentity.func_145837_r()) {
            tileMap.remove(pos);
            tileentity = null;
        }
        return tileentity;
    }

    public static CSModelMetadata getModelByID(int id) {
        return modelData.get(id);
    }

    public static CSModelMetadata getModelFromStack(ItemStack stack) {
        return modelData.get(stack.func_77952_i());
    }

    public static Collection<CSModelMetadata> getAllModelMetadata() {
        return modelData.values();
    }

    public static void addModel(int key, CSModelMetadata data) {
        modelData.put(key, data);
    }

    public static Set<Integer> getAllModelIDs() {
        return modelData.keySet();
    }

    static {
        modelData = new HashMap<Integer, CSModelMetadata>(){

            @Override
            public CSModelMetadata get(Object key) {
                return super.containsKey(key) ? (CSModelMetadata)((Object)super.get(key)) : (CSModelMetadata)((Object)super.get(0));
            }
        };
    }
}

