/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.network;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import team.thegoldenhoe.cameraobscura.CSModelMetadata;
import team.thegoldenhoe.cameraobscura.Utils;
import team.thegoldenhoe.cameraobscura.common.capability.CameraCapabilities;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraNBT;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraStorageNBT;
import team.thegoldenhoe.cameraobscura.common.network.CameraTypes;
import team.thegoldenhoe.cameraobscura.common.network.MessagePhotoDataToServer;
import team.thegoldenhoe.cameraobscura.utils.ModelHandler;

public class PhotoDataHandler {
    private static int photoID = 0;
    private static Map<Integer, TreeSet<MessagePhotoDataToServer>> messageBuffer = new HashMap<Integer, TreeSet<MessagePhotoDataToServer>>();
    private static Queue<MessagePhotoDataToServer> messageQueue = new ConcurrentLinkedQueue<MessagePhotoDataToServer>();

    public static void addMessage(int uuid, MessagePhotoDataToServer message) {
        TreeSet<MessagePhotoDataToServer> messageSet = messageBuffer.get(uuid);
        if (messageSet == null) {
            messageSet = new TreeSet<MessagePhotoDataToServer>(MessagePhotoDataToServer.COMPARATOR);
            messageSet.add(message);
            messageBuffer.put(uuid, messageSet);
        } else {
            messageSet.add(message);
        }
    }

    public static void bufferMessage(MessagePhotoDataToServer message) {
        messageQueue.add(message);
    }

    public static synchronized void processMessageQueue() {
        while (!messageQueue.isEmpty()) {
            MessagePhotoDataToServer msg = messageQueue.poll();
            PhotoDataHandler.addMessage(msg.uuid, msg);
        }
    }

    public static void processMessageBuffer(World world) {
        TreeSet<MessagePhotoDataToServer> messages;
        Set<Integer> uuids = messageBuffer.keySet();
        LinkedList<Integer> completedUuids = new LinkedList<Integer>();
        for (Integer uuid : uuids) {
            messages = messageBuffer.get(uuid);
            int bytesReceived = 0;
            for (MessagePhotoDataToServer message : messages) {
                if ((bytesReceived += message.data.length) != message.length) continue;
                completedUuids.add(uuid);
            }
        }
        for (Integer uuid : completedUuids) {
            messages = messageBuffer.get(uuid);
            byte[] bytes = null;
            ByteBuffer buffer = null;
            UUID photographerUUID = null;
            for (MessagePhotoDataToServer message : messages) {
                if (bytes == null) {
                    bytes = new byte[message.length];
                    buffer = ByteBuffer.wrap(bytes);
                }
                if (photographerUUID == null) {
                    photographerUUID = UUID.fromString(message.playerUUID);
                }
                buffer.put(message.data);
            }
            if (photographerUUID == null) {
                messageBuffer.remove(uuid);
                throw new NullPointerException("Photographer UUID is null, which means we can't produce an item. Sorry :(");
            }
            EntityPlayer player = world.func_152378_a(photographerUUID);
            ItemStack stack = player.func_184614_ca();
            if (!Utils.isCamera(stack)) {
                stack = player.func_184592_cb();
            }
            if (stack.func_190926_b()) {
                messageBuffer.remove(uuid);
                throw new NullPointerException("Camera is null, which means we don't know how to produce the item properly. Sorry :(");
            }
            String savePath = PhotoDataHandler.saveImage(PhotoDataHandler.createImageFromBytes(bytes));
            if (savePath != null) {
                PhotoDataHandler.postImageSaved(player, stack, world, photographerUUID, savePath);
            } else {
                System.err.println("Save path for image was null. This should never happen, but it did. Look at you, you special person!");
            }
            messageBuffer.remove(uuid);
        }
    }

    private static void postImageSaved(EntityPlayer player, ItemStack stack, World world, UUID photographerUUID, String savePath) {
        if (Utils.isCamera(stack)) {
            if (Utils.isCamera(player.func_184614_ca())) {
                stack = player.func_184614_ca();
            } else if (Utils.isCamera(player.func_184592_cb())) {
                stack = player.func_184592_cb();
            }
            CSModelMetadata data = ModelHandler.getModelFromStack(stack);
            CameraTypes type = data.getCameraType();
            if (type != CameraTypes.NOT_A_CAMERA) {
                ICameraNBT cameraCap = (ICameraNBT)stack.getCapability(CameraCapabilities.getCameraCapability(), null);
                ICameraStorageNBT storage = cameraCap.getStorageDevice();
                if (storage.canSave()) {
                    storage.saveImage(savePath, player);
                    if (type == CameraTypes.VINTAGE) {
                        cameraCap.extractItem(0, 1, false);
                    }
                    cameraCap.markDirty();
                } else {
                    System.err.println("Somehow between when the picture was taken and saved, the storage device became full. Whoops!");
                }
            } else {
                System.err.println("Not sure how we got here, but a non camera was trying to save an image. Whoops!");
            }
        }
    }

    private static String saveImage(BufferedImage image) {
        try {
            String dirName = DimensionManager.getCurrentSaveRootDirectory().getAbsolutePath();
            File directory = new File(dirName, "photographs");
            directory.mkdir();
            File imageFile = Utils.getTimestampedPNGFileForDirectory(directory);
            imageFile = imageFile.getCanonicalFile();
            ImageIO.write((RenderedImage)image, "png", imageFile);
            return imageFile.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BufferedImage createImageFromBytes(byte[] bytes) {
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            return ImageIO.read(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getUniqueID() {
        return photoID++;
    }

    public static File getFile(String filename) {
        String dirName = DimensionManager.getCurrentSaveRootDirectory().getAbsolutePath();
        File directory = new File(dirName, "photographs");
        File picture = new File(directory, filename);
        if (picture.exists() && picture.isFile()) {
            return picture;
        }
        return null;
    }
}

