/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.client;

import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.CraftStudioLib;
import com.mia.craftstudio.minecraft.CraftStudioRendererVBO;
import com.mia.craftstudio.minecraft.ModelMetadata;
import com.mia.craftstudio.minecraft.client.CSClientModelWrapperVBO;
import com.mia.craftstudio.minecraft.client.CSClientModelWrapperVariableVBO;
import com.mia.craftstudio.utils.ImageIOCS;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import team.thegoldenhoe.cameraobscura.CSModelMetadata;
import team.thegoldenhoe.cameraobscura.client.ClientEvents;
import team.thegoldenhoe.cameraobscura.client.ClientPhotoCache;
import team.thegoldenhoe.cameraobscura.client.commands.CommandMakeResources;
import team.thegoldenhoe.cameraobscura.client.renderers.RendererProp;
import team.thegoldenhoe.cameraobscura.common.CommonProxy;
import team.thegoldenhoe.cameraobscura.common.craftstudio.TilePictureFrame;
import team.thegoldenhoe.cameraobscura.common.craftstudio.TileProps;
import team.thegoldenhoe.cameraobscura.common.item.ItemRegistry;
import team.thegoldenhoe.cameraobscura.utils.ModelHandler;
import team.thegoldenhoe.cameraobscura.utils.SoundRegistry;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy
implements IResourceManagerReloadListener {
    private ResourceLocation loading = new ResourceLocation("cameraobscura", "textures/others/loading.png");
    private ResourceLocation missing = new ResourceLocation("cameraobscura", "textures/others/missing.png");
    public static boolean photographPending = false;
    public static boolean hideGUIDefault = Minecraft.func_71410_x().field_71474_y.field_74319_N;

    @Override
    public void preInit() {
        ClientEvents.register();
        ClientRegistry.bindTileEntitySpecialRenderer(TileProps.class, (TileEntitySpecialRenderer)new RendererProp());
        ForgeHooksClient.registerTESRItemStack((Item)ItemRegistry.itemProps, (int)0, TileProps.class);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandMakeResources());
    }

    @Override
    public void init() {
        super.init();
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (Integer key : ModelHandler.getAllModelIDs()) {
            itemModelMesher.func_178086_a(ItemRegistry.itemProps, key.intValue(), new ModelResourceLocation("cameraobscura:csitem", "inventory"));
        }
    }

    @Override
    public void setModelResourceLocation(Item item, int meta, String name, String variant) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("cameraobscura:" + name, variant));
        }
    }

    @Override
    public void setupModelWrappers() {
        ArrayList<CSModelMetadata> models = new ArrayList<CSModelMetadata>(ModelHandler.getAllModelMetadata());
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Computing bounding boxes", (int)models.size());
        for (ModelMetadata modelMetadata : models) {
            if (modelMetadata instanceof CSModelMetadata) {
                progressBar.step(((CSModelMetadata)modelMetadata).name);
            } else {
                progressBar.step(modelMetadata.craftstudioAssetName);
            }
            if (modelMetadata instanceof CSModelMetadata && ((CSModelMetadata)modelMetadata).hasVariableRendering) {
                new CSClientModelWrapperVariableVBO(modelMetadata);
            } else {
                new CSClientModelWrapperVBO(modelMetadata);
            }
            for (CSModel.ModelNode node : modelMetadata.csmodel.getTopNodes()) {
                ((CSClientModelWrapperVBO)modelMetadata.wrapper).addRenderer(new CraftStudioRendererVBO(modelMetadata.wrapper.nodeCache.get((Object)node)));
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
        SoundRegistry.registerAllSounds(ModelHandler.getAllModelMetadata());
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.loadResources(resourceManager);
    }

    private void loadResources(IResourceManager resourceManager) {
        CraftStudioLib.getTimer().reset("Total mipmap");
        ArrayList<CSModelMetadata> models = new ArrayList<CSModelMetadata>(ModelHandler.getAllModelMetadata());
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Processing textures", (int)models.size());
        for (ModelMetadata modelMetadata : models) {
            if (modelMetadata instanceof CSModelMetadata) {
                progressBar.step(((CSModelMetadata)modelMetadata).name);
            } else {
                progressBar.step(modelMetadata.craftstudioAssetName);
            }
            BufferedImage modelTexture = modelMetadata.csmodel.getTexture();
            try {
                modelTexture = ImageIOCS.read((InputStream)resourceManager.func_110536_a(new ResourceLocation("cameraobscura".toLowerCase(), String.format("textures/models/%s", modelMetadata.textureOverride))).func_110527_b());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((CSClientModelWrapperVBO)modelMetadata.wrapper).deleteGlTexture();
            ((CSClientModelWrapperVBO)modelMetadata.wrapper).bindGlTexture();
            int mipmapLevels = Minecraft.func_71410_x().field_71474_y.field_151442_I;
            if (mipmapLevels > 0) {
                GL11.glTexParameteri((int)3553, (int)33085, (int)mipmapLevels);
                GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                GL11.glTexParameterf((int)3553, (int)33083, (float)mipmapLevels);
                GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            }
            for (int lvl = 0; lvl <= mipmapLevels; ++lvl) {
                GL11.glTexImage2D((int)3553, (int)lvl, (int)6408, (int)(modelTexture.getWidth() >> lvl), (int)(modelTexture.getHeight() >> lvl), (int)0, (int)32993, (int)33639, (IntBuffer)null);
            }
            int[][] imgArray = new int[1 + mipmapLevels][];
            imgArray[0] = modelTexture.getRGB(0, 0, modelTexture.getWidth(), modelTexture.getHeight(), null, 0, modelTexture.getWidth());
            CraftStudioLib.getTimer().start("mipmap");
            int[][] mipdata = ImageIOCS.generateMipmapData((int)mipmapLevels, (int)modelTexture.getWidth(), (int[][])imgArray);
            CraftStudioLib.getTimer().stop("mipmap");
            CraftStudioLib.getTimer().add("Total mipmap", "mipmap");
            TextureUtil.func_147955_a((int[][])mipdata, (int)modelTexture.getWidth(), (int)modelTexture.getHeight(), (int)0, (int)0, (boolean)false, (boolean)false);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        CraftStudioLib.getTimer().printAcc("Total mipmap");
    }

    @Override
    public int uploadPictureToGPU(int oldID, String pictureLocation, TilePictureFrame.Status status, float aspectRatio) {
        TextureUtil.func_147942_a((int)oldID);
        int glID = 0;
        BufferedImage img = ClientPhotoCache.INSTANCE.getImage(pictureLocation);
        if (status == TilePictureFrame.Status.MISSING) {
            try {
                img = ImageIOCS.read((InputStream)Minecraft.func_71410_x().func_110442_L().func_110536_a(this.missing).func_110527_b());
                glID = TextureUtil.func_110996_a();
                TextureUtil.func_110987_a((int)glID, (BufferedImage)img);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (status == TilePictureFrame.Status.LOADING) {
            try {
                img = ImageIOCS.read((InputStream)Minecraft.func_71410_x().func_110442_L().func_110536_a(this.loading).func_110527_b());
                glID = TextureUtil.func_110996_a();
                TextureUtil.func_110987_a((int)glID, (BufferedImage)img);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (img != null && status == TilePictureFrame.Status.AVAILABLE) {
            int height;
            glID = TextureUtil.func_110996_a();
            int width = img.getWidth();
            float imgAspectRatio = (float)width / (float)(height = img.getHeight());
            if (imgAspectRatio > aspectRatio) {
                int croppedWidth = (int)Math.floor((float)height * aspectRatio);
                int offset = (width - croppedWidth) / 2;
                TextureUtil.func_110987_a((int)glID, (BufferedImage)img.getSubimage(offset, 0, croppedWidth, height));
            } else {
                int croppedHeight = (int)Math.floor((float)width / aspectRatio);
                int offset = (height - croppedHeight) / 2;
                TextureUtil.func_110987_a((int)glID, (BufferedImage)img.getSubimage(0, offset, width, croppedHeight));
            }
        }
        return glID;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

