/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.common.util;

import com.sandvoxel.immersivemagic.ImmersiveMagic;
import com.sandvoxel.immersivemagic.api.blocks.IBlock;
import com.sandvoxel.immersivemagic.common.items.lib.ItemBase;
import com.sandvoxel.immersivemagic.common.spells.SpellTypes;
import com.sandvoxel.immersivemagic.common.spells.lib.SpellBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class RegistryHelper {
    private static List<Block> blocks = new ArrayList<Block>();
    private static List<Item> items = new ArrayList<Item>();

    public static Block addBlockToRegistry(String modid, Class<? extends Block> blockClass) {
        Block block = null;
        String internalName = "";
        try {
            block = blockClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ItemBlock itemBlock = new ItemBlock(block);
            if (block instanceof IBlock) {
                internalName = ((IBlock)block).getInternalName();
            }
            if (!internalName.equals(internalName.toLowerCase(Locale.US))) {
                throw new IllegalArgumentException(String.format("InternalName values need to be all lowercase! Item: %s", internalName));
            }
            if (internalName.isEmpty()) {
                throw new IllegalArgumentException(String.format("InternalName cannot be blank! Item: %s", blockClass.getCanonicalName()));
            }
            block.setRegistryName(modid, internalName);
            block.func_149663_c(internalName);
            itemBlock.setRegistryName(Objects.requireNonNull(block.getRegistryName()));
            blocks.add(block);
            items.add((Item)itemBlock);
        }
        catch (Exception e) {
            ImmersiveMagic.LOGGER.error(String.format("Block %s has had a error : %s", blockClass.getCanonicalName(), e));
        }
        return block;
    }

    public static Item addItemsToRegistry(String modid, Class<? extends ItemBase> itemClass) {
        Item item = null;
        String internalName = null;
        try {
            item = itemClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            internalName = ((ItemBase)item).getInteneralName();
            if (!internalName.equals(internalName.toLowerCase(Locale.US))) {
                throw new IllegalArgumentException(String.format("InternalName values need to be all lowercase! Item: %s", internalName));
            }
            if (internalName.isEmpty()) {
                throw new IllegalArgumentException(String.format("InternalName cannot be blank! Item: %s", itemClass.getCanonicalName()));
            }
            item.func_77655_b(internalName);
            item.setRegistryName(modid, internalName);
            items.add(item);
        }
        catch (Exception e) {
            ImmersiveMagic.LOGGER.error(String.format("Item %s has had a error : %s", itemClass.getCanonicalName(), e));
        }
        return item;
    }

    public static void initItemBlocks(Block block) {
        try {
            Item itemBlock = Item.func_150898_a((Block)block);
            ModelResourceLocation model = new ModelResourceLocation(String.format("%s", block.getRegistryName()));
            ModelBakery.registerItemVariants((Item)itemBlock, (ResourceLocation[])new ResourceLocation[]{model});
            ItemMeshDefinition meshDefinition = stack -> model;
            ModelLoader.setCustomMeshDefinition((Item)itemBlock, (ItemMeshDefinition)meshDefinition);
        }
        catch (Exception e) {
            ImmersiveMagic.LOGGER.error(String.format("Failed to initialize ItemBlock for: %s || %s", block.func_149739_a(), e));
        }
    }

    public static Item spellRegstration(Class<? extends SpellBase> spellClass, int id) {
        Item item = null;
        try {
            item = spellClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            String internalName = ((SpellBase)item).getInteneralName();
            ImmersiveMagic.LOGGER.info(spellClass);
            if (!internalName.equals(internalName.toLowerCase(Locale.US))) {
                throw new IllegalArgumentException(String.format("InternalName values need to be all lowercase! Item: %s", internalName));
            }
            if (internalName.isEmpty()) {
                throw new IllegalArgumentException(String.format("InternalName cannot be blank! Item: %s", spellClass.getCanonicalName()));
            }
            item.func_77655_b(internalName);
            item.setRegistryName("immmag", internalName);
            items.add(item);
            ImmersiveMagic.LOGGER.info("Added spell Item " + item);
            if (((SpellBase)item).getSpellType() == SpellTypes.THROWABLE_SPELL) {
                ((SpellBase)item).RegisterSpellEntity(id);
            }
        }
        catch (Exception e) {
            ImmersiveMagic.LOGGER.error(String.format("Failed to initialize Spell for: %s || %s", spellClass.getCanonicalName(), e));
        }
        return item;
    }

    public static List<Block> getBlocks() {
        return blocks;
    }

    public static List<Item> getItemBlocks() {
        return items;
    }
}

