/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.common.spells.entity;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SpellEntityBase
extends EntityThrowable {
    protected EnumParticleTypes spellParticleType;
    protected Double projPartVel = 1.0;
    protected Double impactPartVel = 2.5;
    protected Double fizzlePartVel = 2.0;
    protected int deathParticleNum = 250;
    protected boolean hasGravity = false;

    public SpellEntityBase(World worldIn) {
        super(worldIn);
        this.field_70145_X = false;
    }

    public SpellEntityBase(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.spellParticleType = EnumParticleTypes.SPELL;
        this.func_189654_d(true);
        this.field_70145_X = false;
    }

    public SpellEntityBase(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
        this.func_189654_d(true);
    }

    public SpellEntityBase(World worldIn, EntityLivingBase throwerIn, boolean hasGravity, EnumParticleTypes spellParticle) {
        super(worldIn, throwerIn);
        this.hasGravity = hasGravity;
        if (!hasGravity) {
            this.func_189654_d(true);
        }
        this.spellParticleType = spellParticle;
        this.field_70145_X = false;
    }

    public SpellEntityBase(World worldIn, EntityLivingBase throwerIn, boolean hasGravity, EnumParticleTypes spellParticle, double impactPartVel, double projectilePartVel, double fizzlePartVel) {
        super(worldIn, throwerIn);
        this.hasGravity = hasGravity;
        if (!hasGravity) {
            this.func_189654_d(true);
        }
        this.spellParticleType = spellParticle;
        this.impactPartVel = impactPartVel;
        this.projPartVel = projectilePartVel;
        this.fizzlePartVel = fizzlePartVel;
        this.field_70145_X = false;
    }

    public void func_70030_z() {
        this.spawnParticleTrail(this.spellParticleType);
        if (!this.hasGravity && Math.abs(this.field_70159_w) < 0.05 && Math.abs(this.field_70181_x) < 0.05 && Math.abs(this.field_70179_y) < 0.05) {
            this.field_70128_L = true;
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < this.deathParticleNum; ++i) {
                    this.field_70170_p.func_175688_a(this.spellParticleType, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * this.fizzlePartVel, (this.field_70146_Z.nextDouble() - 0.5) * this.fizzlePartVel, (this.field_70146_Z.nextDouble() - 0.5) * this.fizzlePartVel, new int[0]);
                }
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        this.impactDeathHandling(result, 4);
    }

    protected void impactDeathHandling(RayTraceResult result, int numberOfParticles) {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < numberOfParticles; ++i) {
                this.field_70170_p.func_175688_a(this.spellParticleType, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * this.impactPartVel, (this.field_70146_Z.nextDouble() - 0.5) * this.impactPartVel, (this.field_70146_Z.nextDouble() - 0.5) * this.impactPartVel, new int[0]);
            }
        }
        if (result.field_72308_g == null) {
            this.field_70128_L = true;
        }
    }

    protected void spawnParticleTrail(EnumParticleTypes type) {
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(type, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * -this.field_70159_w * this.projPartVel, (this.field_70146_Z.nextDouble() - 0.5) * -this.field_70181_x * this.projPartVel, (this.field_70146_Z.nextDouble() - 0.5) * -this.field_70179_y * this.projPartVel, new int[0]);
        }
    }

    protected void impactDeathHandling(RayTraceResult result, int numberOfParticles, EnumParticleTypes particleType) {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < numberOfParticles; ++i) {
                this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * this.impactPartVel, (this.field_70146_Z.nextDouble() - 0.5) * this.impactPartVel, (this.field_70146_Z.nextDouble() - 0.5) * this.impactPartVel, new int[0]);
            }
        }
        if (result.field_72308_g == null) {
            this.field_70128_L = true;
        }
    }

    public void setSpellParticleType(EnumParticleTypes particleType) {
        this.spellParticleType = particleType;
    }

    public EnumParticleTypes getSpellParticleType() {
        return this.spellParticleType;
    }

    public void setImpactPartVel(double velocity) {
        this.impactPartVel = velocity;
    }

    public double getImpactPartVel() {
        return this.impactPartVel;
    }

    public void setProjectilePartVel(double velocity) {
        this.projPartVel = velocity;
    }

    public double getProjectilePartVel() {
        return this.projPartVel;
    }

    public void setFizzlePartVel(double velocity) {
        this.fizzlePartVel = velocity;
    }

    public double getFizzlePartVel() {
        return this.fizzlePartVel;
    }
}

