/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.common.network.lib;

import com.sandvoxel.immersivemagic.common.network.lib.PacketBase;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkWrapperBase {
    public final SimpleNetworkWrapper network;
    protected final PacketHandlerBase handler;
    private int id = 0;

    public NetworkWrapperBase(String channelName) {
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(channelName);
        this.handler = new PacketHandlerBase();
    }

    public void registerPacket(Class<? extends PacketBase> clazz) {
        this.registerPacketClient(clazz);
        this.registerPacketServer(clazz);
    }

    public void registerPacketClient(Class<? extends PacketBase> clazz) {
        this.registerPacketImp(clazz, Side.CLIENT);
    }

    public void registerPacketServer(Class<? extends PacketBase> clazz) {
        this.registerPacketImp(clazz, Side.SERVER);
    }

    private void registerPacketImp(Class<? extends PacketBase> clazz, Side side) {
        this.network.registerMessage((IMessageHandler)this.handler, clazz, this.id++, side);
    }

    public static class PacketHandlerBase
    implements IMessageHandler<PacketBase, IMessage> {
        public IMessage onMessage(PacketBase message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                return message.handleServer(ctx.getServerHandler());
            }
            return message.handleClient(ctx.getClientHandler());
        }
    }
}

