/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.common.network;

import com.sandvoxel.immersivemagic.ImmersiveMagic;
import com.sandvoxel.immersivemagic.api.magic.IAffinities;
import com.sandvoxel.immersivemagic.common.magicdata.AffinitiesProvider;
import com.sandvoxel.immersivemagic.common.magicdata.AffinityTypes;
import com.sandvoxel.immersivemagic.common.network.lib.PacketBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AffinityPacket
extends PacketBase {
    private boolean[] hasAffinityArr = new boolean[8];
    private int entityID;
    private EntityPlayer player;

    public AffinityPacket() {
        ImmersiveMagic.LOGGER.info("Initialized without any parameters!");
    }

    public AffinityPacket(IAffinities playerAffinities, EntityPlayer player) {
        ImmersiveMagic.LOGGER.info("Initialized with parameters!");
        for (AffinityTypes type : AffinityTypes.values()) {
            this.hasAffinityArr[type.getMeta()] = playerAffinities.hasAffinity(type);
        }
        this.player = player;
    }

    @Override
    public IMessage handleClient(NetHandlerPlayClient netHandler) {
        ImmersiveMagic.LOGGER.info(this.hasAffinityArr);
        this.player = Minecraft.func_71410_x().field_71439_g;
        IAffinities aff = (IAffinities)this.player.getCapability(AffinitiesProvider.AFFINITIES_CAPABILITY, null);
        for (AffinityTypes type : AffinityTypes.values()) {
            if (this.hasAffinityArr[type.getMeta()]) {
                aff.addAffinities(type);
                continue;
            }
            aff.removeAffinity(type);
        }
        for (AffinityTypes type : AffinityTypes.values()) {
            ImmersiveMagic.LOGGER.info(type.getName() + ":. " + ((IAffinities)this.player.getCapability(AffinitiesProvider.AFFINITIES_CAPABILITY, null)).hasAffinity(type));
        }
        return null;
    }

    @Override
    public IMessage handleServer(NetHandlerPlayServer netHandler) {
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
        for (int i = 0; i < this.hasAffinityArr.length; ++i) {
            ImmersiveMagic.LOGGER.info(i);
            this.hasAffinityArr[i] = buf.readBoolean();
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.player.func_145782_y(), (int)4);
        for (boolean bool : this.hasAffinityArr) {
            buf.writeBoolean(bool);
        }
    }
}

