/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.common.network;

import com.sandvoxel.immersivemagic.ImmersiveMagic;
import com.sandvoxel.immersivemagic.api.magic.IAffinities;
import com.sandvoxel.immersivemagic.common.magicdata.AffinitiesProvider;
import com.sandvoxel.immersivemagic.common.magicdata.AffinityTypes;
import com.sandvoxel.immersivemagic.common.network.AffinityPacket;
import com.sandvoxel.immersivemagic.common.network.lib.Network;
import com.sandvoxel.immersivemagic.common.network.lib.PacketBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AffinityGuiPacket
extends PacketBase {
    private int id;
    private int power;
    private int mana;
    private boolean active;
    private int affinityCap = 3;

    public AffinityGuiPacket() {
    }

    public AffinityGuiPacket(int id, int power) {
        this.id = id;
        this.power = power;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.power = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.power);
    }

    @Override
    public IMessage handleClient(NetHandlerPlayClient netHandler) {
        return null;
    }

    @Override
    public IMessage handleServer(NetHandlerPlayServer netHandler) {
        AffinityTypes affinityType;
        IAffinities affinities = (IAffinities)netHandler.field_147369_b.getCapability(AffinitiesProvider.AFFINITIES_CAPABILITY, null);
        if (affinities.hasAffinity(affinityType = AffinityTypes.getAffinity(this.id))) {
            affinities.removeAffinity(affinityType);
            ImmersiveMagic.LOGGER.info("Removed affinity '" + affinityType.getName() + "' from player " + netHandler.field_147369_b.func_70005_c_());
        } else if (!affinities.hasAffinity(affinityType)) {
            int activeNum = 0;
            AffinityTypes[] affinityTypesArray = AffinityTypes.values();
            int n = affinityTypesArray.length;
            for (int i = 0; i < n; ++i) {
                AffinityTypes type = affinityTypesArray[i];
                if (!affinities.hasAffinity(type)) continue;
                ++activeNum;
            }
            if (activeNum >= this.affinityCap) {
                ImmersiveMagic.LOGGER.info("Player " + netHandler.field_147369_b.func_70005_c_() + " already has " + activeNum + " affinities. Cannot add " + affinityType.getName() + "!");
            } else {
                affinities.addAffinities(affinityType);
                ImmersiveMagic.LOGGER.info("Added affinity '" + affinityType.getName() + "' to player " + netHandler.field_147369_b.func_70005_c_());
            }
        } else {
            ImmersiveMagic.LOGGER.info("Mis-match between affinity status request and actual affinity status. Server is out of sync with " + netHandler.field_147369_b.func_70005_c_() + " for affinity '" + affinityType.getName() + "'!");
        }
        ImmersiveMagic.LOGGER.info("About to send AffinityPacket ");
        for (AffinityTypes type : AffinityTypes.values()) {
            ImmersiveMagic.LOGGER.info(type.getName() + ": " + affinities.hasAffinity(type));
        }
        Network.sendTo(new AffinityPacket(affinities, (EntityPlayer)netHandler.field_147369_b), netHandler.field_147369_b);
        return null;
    }
}

