/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.common.magicdata;

public enum AffinityTypes {
    FIRE(0, "fire"),
    WATER(1, "water"),
    ICE(2, "ice"),
    AIR(3, "air"),
    EARTH(4, "earth"),
    ENDER(5, "ender"),
    LIGHT(6, "light"),
    DARKNESS(7, "darkness");

    private static final AffinityTypes[] ID_LOOKUP;
    private int ID;
    private String Name;

    private AffinityTypes(int ID, String name) {
        this.ID = ID;
        this.Name = name;
    }

    public int getMeta() {
        return this.ordinal();
    }

    public static AffinityTypes getAffinity(int ID) {
        if (ID < 0 || ID >= ID_LOOKUP.length) {
            ID = 0;
        }
        return ID_LOOKUP[ID];
    }

    public String getName() {
        return this.Name;
    }

    public static int getAffinityID(AffinityTypes affinityTypes) {
        return affinityTypes.ID;
    }

    static {
        ID_LOOKUP = new AffinityTypes[AffinityTypes.values().length];
        AffinityTypes[] affinityTypesArray = AffinityTypes.values();
        int n = affinityTypesArray.length;
        for (int i = 0; i < n; ++i) {
            AffinityTypes tier;
            AffinityTypes.ID_LOOKUP[tier.ID] = tier = affinityTypesArray[i];
        }
    }
}

