/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.common.magicdata;

import com.sandvoxel.immersivemagic.ImmersiveMagic;
import com.sandvoxel.immersivemagic.api.magic.IAffinities;
import com.sandvoxel.immersivemagic.common.magicdata.AffinityObject;
import com.sandvoxel.immersivemagic.common.magicdata.AffinityTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class Affinities
implements IAffinities {
    private EntityPlayer player;
    private List<AffinityObject> affinityObjects = new ArrayList<AffinityObject>();

    public Affinities(EntityPlayer player) {
        this.player = player;
        for (AffinityTypes types : AffinityTypes.values()) {
            this.affinityObjects.add(new AffinityObject(types));
        }
    }

    @Override
    public List<AffinityObject> getPlayerAffinities() {
        return this.affinityObjects;
    }

    @Override
    public void addAffinities(AffinityTypes affinityType) {
        this.affinityObjects.get(affinityType.getMeta()).setActive(true);
    }

    @Override
    public void removeAffinity(AffinityTypes affinityType) {
        this.affinityObjects.get(affinityType.getMeta()).setActive(false);
    }

    @Override
    public int getAffinityLevel(AffinityTypes affinityType) {
        return this.affinityObjects.get(affinityType.getMeta()).getAffinityPower();
    }

    @Override
    public int getAffinityMana(AffinityTypes affinityType) {
        return this.affinityObjects.get(affinityType.getMeta()).getAffinityMana();
    }

    @Override
    public boolean canCast(int manaCost, AffinityTypes affinityType) {
        AffinityObject affinity = this.affinityObjects.get(affinityType.getMeta());
        if (this.player.func_184812_l_()) {
            return true;
        }
        if (affinity.getAffinityMana() >= manaCost) {
            this.affinityObjects.get(affinityType.getMeta()).setAffinityMana(affinity.getAffinityMana() - manaCost);
            return true;
        }
        return false;
    }

    @Override
    public int getManaCap(AffinityTypes affinityType) {
        return this.affinityObjects.get(affinityType.getMeta()).getManaCap();
    }

    @Override
    public void addXp(int XP, AffinityTypes affinityType) {
        this.affinityObjects.get(affinityType.getMeta()).setCurrentXP(this.affinityObjects.get(affinityType.getMeta()).getCurrentXP() + XP);
        this.affinityObjects.get(affinityType.getMeta()).canLevelUp();
        ImmersiveMagic.LOGGER.info(affinityType.getName() + ": " + this.affinityObjects.get(affinityType.getMeta()).getAffinityPower());
    }

    @Override
    public void setPlayerAffinities(List<AffinityObject> nbt) {
        this.affinityObjects.clear();
        this.affinityObjects = nbt;
    }

    @Override
    public boolean hasAffinity(AffinityTypes affinityTypes) {
        return this.affinityObjects.get(affinityTypes.getMeta()).isActive();
    }
}

