/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.common.inventory;

import com.sandvoxel.immersivemagic.api.inventory.IInventoryHandler;
import com.sandvoxel.immersivemagic.common.inventory.InventoryIterable;
import com.sandvoxel.immersivemagic.common.inventory.InventoryOperation;
import com.sandvoxel.immersivemagic.common.util.Platform;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class InternalInventory
implements IInventory,
Iterable<ItemStack> {
    protected int size;
    protected int maxsize = 0;
    public boolean enableClientEvents = false;
    public final ItemStack[] inventory;
    IInventoryHandler inventoryHandler;

    public InternalInventory(IInventoryHandler inventory, int size) {
        this.size = size;
        this.inventoryHandler = inventory;
        this.inventory = new ItemStack[size];
        this.maxsize = 64;
        for (int i = 0; i < size; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
    }

    protected boolean eventsEnabled() {
        return Platform.isServer() || this.enableClientEvents;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.size; ++i) {
            if (this.func_70301_a(i) == ItemStack.field_190927_a) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new InventoryIterable(this, this.maxsize);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory[index] != ItemStack.field_190927_a) {
            ItemStack newStack;
            ItemStack split = this.func_70301_a(index);
            if (count >= split.func_190916_E()) {
                newStack = this.inventory[index];
                this.inventory[index] = ItemStack.field_190927_a;
            } else {
                newStack = split.func_77979_a(count);
            }
            if (this.inventoryHandler != null && this.eventsEnabled()) {
                this.inventoryHandler.onChangeInventory(this, index, InventoryOperation.decreaseStackSize, newStack, ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack oldStack = this.inventory[index];
        this.inventory[index] = stack;
        if (this.inventoryHandler != null && this.eventsEnabled()) {
            ItemStack removed = oldStack;
            ItemStack added = stack;
            if (oldStack != ItemStack.field_190927_a && stack != ItemStack.field_190927_a && Platform.isSameItem(oldStack, stack)) {
                if (oldStack.func_190916_E() > stack.func_190916_E()) {
                    removed = removed.func_77946_l();
                    removed.func_190918_g(stack.func_190916_E());
                } else if (oldStack.func_190916_E() < stack.func_190916_E()) {
                    added = added.func_77946_l();
                    added.func_190918_g(oldStack.func_190916_E());
                    removed = ItemStack.field_190927_a;
                } else {
                    removed = added = ItemStack.field_190927_a;
                }
            }
            this.inventoryHandler.onChangeInventory(this, index, InventoryOperation.setInventorySlotContents, removed, added);
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return this.maxsize > 64 ? 64 : this.maxsize;
    }

    public void func_70296_d() {
        if (this.inventoryHandler != null && this.eventsEnabled()) {
            this.inventoryHandler.onChangeInventory(this, -1, InventoryOperation.markDirty, ItemStack.field_190927_a, ItemStack.field_190927_a);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public void setMaxsize(int maxsize) {
        this.maxsize = maxsize;
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "internal";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }
}

