/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.common.blocks;

import com.google.common.collect.Maps;
import com.sandvoxel.immersivemagic.common.blocks.LIb.BlockBase;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LiquefactedBlock
extends BlockBase {
    protected static final PropertyEnum<LiqBlockTypes> LIQ_BLOCK_TYPE = PropertyEnum.func_177709_a((String)"liq_block_type", LiqBlockTypes.class);

    public LiquefactedBlock() {
        super(Material.field_151578_c, "block_liquefacted");
        this.setInternalName("block_liquefacted");
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185849_b);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        if (itemIn != null) {
            return;
        }
        for (LiqBlockTypes liqType : LiqBlockTypes.values()) {
            items.add((Object)new ItemStack((Block)this, 1, liqType.getMeta()));
        }
    }

    public static PropertyEnum getProperty() {
        return LIQ_BLOCK_TYPE;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(LIQ_BLOCK_TYPE, (Comparable)((Object)LiqBlockTypes.byMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        LiqBlockTypes type = (LiqBlockTypes)((Object)state.func_177229_b(LIQ_BLOCK_TYPE));
        return type.getMeta();
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.field_70159_w *= (double)0.35f;
        entityIn.field_70181_x = entityIn.field_70181_x <= 0.0 ? (entityIn.field_70181_x *= (double)0.01f) : (entityIn.field_70181_x *= (double)0.9f);
        entityIn.field_70179_y *= (double)0.35f;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int blockToPlace = LiqBlockTypes.getBlockID(LiqBlockTypes.byMeta(this.func_176201_c(state)));
        switch (blockToPlace) {
            case 1: {
                worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176203_a(1));
            }
            case 3: {
                worldIn.func_175656_a(pos, Blocks.field_150354_m.func_176203_a(1));
            }
        }
        worldIn.func_175656_a(pos, LiqBlockTypes.byMeta(this.func_176201_c(state)).getDrop().func_176223_P());
        super.func_180650_b(worldIn, pos, state, rand);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIQ_BLOCK_TYPE});
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a(LIQ_BLOCK_TYPE, (Comparable)((Object)LiqBlockTypes.byMeta(stack.func_77960_j()))));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(LIQ_BLOCK_TYPE, (Comparable)((Object)LiqBlockTypes.byMeta(this.func_176201_c(state))));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockRenderer() {
        final String resourcePath = String.format("%s:%s", "immmag", this.resourcePath);
        final String badPath = String.format("%s:badblock", "immmag");
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                LinkedHashMap blockStates = Maps.newLinkedHashMap((Map)state.func_177228_b());
                if (!Arrays.asList(LiqBlockTypes.values()).contains(blockStates.get(LIQ_BLOCK_TYPE))) {
                    return new ModelResourceLocation(badPath, "");
                }
                if (blockStates.containsKey(LIQ_BLOCK_TYPE)) {
                    blockStates.remove(LIQ_BLOCK_TYPE);
                }
                return new ModelResourceLocation(resourcePath, this.func_178131_a(blockStates));
            }
        });
    }

    public static enum LiqBlockTypes implements IStringSerializable
    {
        DIRT(Blocks.field_150346_d, "dirt", 0),
        DIRT_COARSE(Blocks.field_150346_d, "dirt_c", 1),
        SAND((Block)Blocks.field_150354_m, "sand", 2),
        RED_SAND((Block)Blocks.field_150354_m, "sand_r", 3),
        GRAVEL(Blocks.field_150351_n, "gravel", 4),
        SOULSAND(Blocks.field_150425_aM, "soulsand", 5);

        private static final LiqBlockTypes[] META_LOOKUP;
        private int ID;
        private String Name;
        private Block drop;

        private LiqBlockTypes(Block drops, String name, int ID) {
            this.drop = drops;
            this.ID = ID;
            this.Name = name;
        }

        public String func_176610_l() {
            return this.Name;
        }

        public Block getDrop() {
            return this.drop;
        }

        public int getIDFromDrop(Block drop) {
            LiqBlockTypes[] liqBlockTypesArray = LiqBlockTypes.values();
            int n = liqBlockTypesArray.length;
            for (int i = 0; i < n; ++i) {
                LiqBlockTypes type;
                LiqBlockTypes.META_LOOKUP[type.ID] = type = liqBlockTypesArray[i];
                if (drop != type.getDrop()) continue;
                return type.ID;
            }
            if (drop == Blocks.field_150349_c || drop == Blocks.field_150391_bh || drop == Blocks.field_185774_da) {
                return 0;
            }
            return 0;
        }

        public static int getBlockID(LiqBlockTypes blockTypes) {
            return blockTypes.ID;
        }

        public int getMeta() {
            return this.ID;
        }

        public static LiqBlockTypes byMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new LiqBlockTypes[LiqBlockTypes.values().length];
            LiqBlockTypes[] liqBlockTypesArray = LiqBlockTypes.values();
            int n = liqBlockTypesArray.length;
            for (int i = 0; i < n; ++i) {
                LiqBlockTypes type;
                LiqBlockTypes.META_LOOKUP[type.ID] = type = liqBlockTypesArray[i];
            }
        }
    }
}

