/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.common.blocks.LIb;

import com.sandvoxel.immersivemagic.common.blocks.LIb.BlockBase;
import com.sandvoxel.immersivemagic.common.tileentitys.TileEntityBase;
import com.sandvoxel.immersivemagic.common.util.TileHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BlockTileBase
extends BlockBase {
    @Nonnull
    private Class<? extends TileEntity> tileEntityClass;

    public BlockTileBase(Material blockMaterialIn, String resourcePath) {
        super(blockMaterialIn, resourcePath);
    }

    protected void setTileEntity(Class<? extends TileEntity> clazz) {
        this.tileEntityClass = clazz;
        this.setTileProvider(true);
        this.isInventory = IInventory.class.isAssignableFrom(clazz);
        String tileName = "tile.immmag." + clazz.getSimpleName();
        GameRegistry.registerTileEntity(this.tileEntityClass, (String)tileName);
    }

    @Nullable
    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        TileEntityBase tileEntity = TileHelper.getTileEntity((IBlockAccess)world, pos, TileEntityBase.class);
        if (tileEntity != null && tileEntity.canBeRotated()) {
            return EnumFacing.field_176754_o;
        }
        return super.getValidRotations(world, pos);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityBase tileEntity = TileHelper.getTileEntity((IBlockAccess)worldIn, pos, TileEntityBase.class);
        if (tileEntity != null) {
            tileEntity.dropItems();
        }
    }

    private void setTileProvider(boolean b) {
        ReflectionHelper.setPrivateValue(Block.class, (Object)this, (Object)b, (String[])new String[]{"isTileProvider"});
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        try {
            return this.tileEntityClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Failed to create a new instance of an illegal class " + this.tileEntityClass, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Failed to create a new instance of " + this.tileEntityClass + " because of a lack of permissions", ex);
        }
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return this.tileEntityClass;
    }
}

