/*
 * Decompiled with CFR 0.152.
 */
package com.sandvoxel.immersivemagic.client.gui;

import com.sandvoxel.immersivemagic.common.util.GuiHelper;
import com.sandvoxel.immersivemagic.common.util.OpenGLHelper;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiBase
extends GuiContainer {
    protected final String modId;
    protected int colorBackground = new Color(56, 55, 69, 224).hashCode();
    protected int colorBorder = new Color(48, 41, 69).hashCode();
    protected int colorFont = new Color(255, 255, 255).hashCode();
    protected int colorErrorFont = new Color(255, 64, 64).hashCode();
    protected int colorProgressBackground = new Color(64, 64, 255, 128).hashCode();
    protected int colorProgressBackgroundGood = new Color(0, 170, 0).hashCode();
    protected int colorProgressBackgroundWarn = new Color(255, 170, 0).hashCode();
    protected int colorProgressBackgroundBad = new Color(255, 85, 85).hashCode();
    protected int colorXPGreen = new Color(128, 255, 32).hashCode();
    GuiHelper guiHelper;

    public GuiBase(String modId, Container container) {
        super(container);
        this.modId = modId;
        this.guiHelper = new GuiHelper();
    }

    public void drawTooltip(int mouseX, int mouseY, int forceWidth, String message) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int[][] savedGLState = OpenGLHelper.saveGLState(new int[]{3008, 2896});
        GL11.glPushMatrix();
        this.guiHelper.drawWindowWithBorder(mouseX, mouseY, forceWidth, 10, this.colorBackground, this.colorBorder);
        this.guiHelper.drawCenteredStringWithShadow(mouseX, mouseY, forceWidth, "Hello World", this.colorFont);
        GL11.glPopMatrix();
        OpenGLHelper.restoreGLState(savedGLState);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public abstract void drawBG(int var1, int var2, int var3, int var4);

    public abstract void drawFG(int var1, int var2, int var3, int var4);

    public void bindTexture(String base, String file) {
        ResourceLocation resourceLocation = new ResourceLocation(base, "textures/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(resourceLocation);
    }

    public void bindTexture(String file) {
        ResourceLocation resourceLocation = new ResourceLocation(this.modId, "textures/" + file);
        this.field_146297_k.func_110434_K().func_110577_a(resourceLocation);
    }

    protected final void func_146976_a(float f, int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBG(ox, oy, x, y);
    }

    protected final void func_146979_b(int x, int y) {
        int ox = this.field_147003_i;
        int oy = this.field_147009_r;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawFG(ox, oy, x, y);
    }

    protected Slot getSlot(int mouseX, int mouseY) {
        for (int j1 = 0; j1 < this.field_147002_h.field_75151_b.size(); ++j1) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(j1);
            if (!this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    protected void drawTransparentIconEmpty(Slot slot, ItemStack itemStack) {
        if (slot.func_75216_d()) {
            return;
        }
        this.drawTransparentIcon(slot, itemStack);
    }

    protected void drawIconEmpty(Slot slot, ItemStack itemStack) {
        if (slot.func_75216_d()) {
            return;
        }
        this.drawIcon(slot, itemStack);
    }

    protected void drawTransparentIcon(Slot slot, ItemStack itemStack) {
        ItemStack displayStack = itemStack.func_77946_l();
        if (itemStack.func_77952_i() == Short.MAX_VALUE) {
            displayStack.func_77964_b(0);
        }
        this.guiHelper.drawItemStack(displayStack, slot.field_75223_e + this.field_147003_i, slot.field_75221_f + this.field_147009_r, this.field_146296_j, true);
    }

    protected void drawIcon(Slot slot, ItemStack itemStack) {
        ItemStack displayStack = itemStack.func_77946_l();
        if (itemStack.func_77952_i() == Short.MAX_VALUE) {
            displayStack.func_77964_b(0);
        }
        this.guiHelper.drawItemStack(itemStack, slot.field_75223_e + this.field_147003_i, slot.field_75221_f + this.field_147009_r, this.field_146296_j, false);
    }

    public void renderToolTip(List<String> messages, int x, int y) {
        this.drawHoveringText(messages, x, y, this.field_146289_q);
    }
}

