/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct.tileentities;

import com.jarhax.jewelersconstruct.api.JewelryHelper;
import com.jarhax.jewelersconstruct.api.material.Material;
import com.jarhax.jewelersconstruct.api.modifier.Modifier;
import com.jarhax.jewelersconstruct.api.part.PartType;
import com.jarhax.jewelersconstruct.api.trinket.TrinketType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.darkhax.bookshelf.block.tileentity.TileEntityBasicTickable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityTrinketForge
extends TileEntityBasicTickable {
    private final ItemStackHandler inventory;
    private TrinketType lastType = (TrinketType)((Object)JewelryHelper.TRINKET_TYPES.getValues().get(0));

    public TileEntityTrinketForge() {
        this.inventory = new ItemStackHandler(6);
    }

    public void onEntityUpdate() {
        if (this.inventory.getStackInSlot(5).func_190926_b()) {
            boolean valid = true;
            if (this.inventory.getStackInSlot(4).func_190926_b()) {
                for (int i = 0; i < this.getLastType().getPartTypes().length; ++i) {
                    PartType type = this.getLastType().getPartTypes()[i];
                    if (!this.getInventory().getStackInSlot(i).func_190926_b()) {
                        if (this.getInventory().getStackInSlot(i).func_77973_b() == type.getPartItem()) continue;
                        valid = false;
                        continue;
                    }
                    valid = false;
                }
                if (valid) {
                    ItemStack stack = new ItemStack((Item)this.getLastType().getTrinketItem());
                    HashMap<Modifier, Integer> modifierMap = new HashMap<Modifier, Integer>();
                    LinkedList<Material> materials = new LinkedList<Material>();
                    for (int i = 0; i < this.getInventory().getSlots(); ++i) {
                        ItemStack slot = this.getInventory().getStackInSlot(i);
                        if (slot.func_190926_b()) continue;
                        Map<Modifier, Integer> map = JewelryHelper.getModifiers(slot);
                        if (!map.isEmpty()) {
                            for (Map.Entry<Modifier, Integer> entry : map.entrySet()) {
                                modifierMap.merge(entry.getKey(), entry.getValue(), (integer, integer2) -> integer + integer2);
                            }
                        }
                        materials.add(JewelryHelper.getPartMaterial(slot));
                    }
                    JewelryHelper.setJewelryMaterials(stack, materials);
                    JewelryHelper.setModifiers(stack, modifierMap);
                    this.getInventory().setStackInSlot(4, stack);
                }
            }
        } else if (this.inventory.getStackInSlot(4).func_190926_b()) {
            ItemStack stack = this.inventory.getStackInSlot(5).func_77946_l();
            Map<Modifier, Integer> modifierMap = JewelryHelper.getModifiers(stack);
            for (int i = 0; i < this.getInventory().getSlots(); ++i) {
                Modifier modifier;
                ItemStack slot;
                if (i == 5 || (slot = this.getInventory().getStackInSlot(i)).func_190926_b()) continue;
                Map<Modifier, Integer> map = JewelryHelper.getModifiers(slot);
                if (!map.isEmpty()) {
                    for (Map.Entry<Modifier, Integer> entry : map.entrySet()) {
                        modifierMap.merge(entry.getKey(), entry.getValue(), (integer, integer2) -> integer + integer2);
                    }
                }
                if ((modifier = (Modifier)((Object)JewelryHelper.INPUTS_TO_MODIFIERS.get((Object)slot))) == null) continue;
                modifierMap.merge(modifier, 1, (integer, integer2) -> integer + integer2);
            }
            JewelryHelper.setModifiers(stack, modifierMap);
            this.getInventory().setStackInSlot(4, stack.func_77946_l());
        }
    }

    public void writeNBT(NBTTagCompound dataTag) {
        dataTag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (this.getLastType() != null) {
            dataTag.func_74778_a("lastPart", this.getLastType().getRegistryName().toString());
        }
    }

    public void readNBT(NBTTagCompound dataTag) {
        this.inventory.deserializeNBT(dataTag.func_74775_l("inventory"));
        this.lastType = JewelryHelper.getTrinketTypeByName(dataTag.func_74779_i("lastPart"));
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public TrinketType getLastType() {
        return this.lastType;
    }

    public void setLastType(TrinketType lastType) {
        this.lastType = lastType;
    }
}

