/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct.tileentities;

import com.jarhax.jewelersconstruct.api.JewelryHelper;
import com.jarhax.jewelersconstruct.api.material.Material;
import com.jarhax.jewelersconstruct.api.part.PartType;
import net.darkhax.bookshelf.block.tileentity.TileEntityBasicTickable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityPartShaper
extends TileEntityBasicTickable {
    private final ItemStackHandler inventory;
    private int fuel = 0;
    private int fuelTotal = 0;
    private boolean processing = false;
    private int progress = 0;
    private final int progressMax = 200;
    private PartType lastType = (PartType)((Object)JewelryHelper.PART_TYPES.getValues().get(0));

    public TileEntityPartShaper() {
        this.inventory = new ItemStackHandler(3);
    }

    public void onEntityUpdate() {
        if (this.processing) {
            if (this.fuel <= 0) {
                this.fuelTotal = 0;
                ItemStack fuelSlot = this.getInventory().getStackInSlot(1);
                if (!fuelSlot.func_190926_b() && TileEntityFurnace.func_145952_a((ItemStack)fuelSlot) > 0) {
                    this.fuelTotal = this.fuel = TileEntityFurnace.func_145952_a((ItemStack)fuelSlot);
                    Item item = fuelSlot.func_77973_b();
                    fuelSlot.func_190918_g(1);
                    if (fuelSlot.func_190926_b()) {
                        this.getInventory().setStackInSlot(1, item.getContainerItem(fuelSlot));
                    }
                }
            }
            if (this.fuel > 0) {
                --this.fuel;
                ++this.progress;
                if (this.progress >= this.progressMax) {
                    this.progress = 0;
                    this.processing = false;
                    Material material = JewelryHelper.getMaterial(this.inventory.getStackInSlot(0));
                    if (material.isValidForPart(this.getLastType())) {
                        this.inventory.getStackInSlot(0).func_190918_g(1);
                        ItemStack itemStack = new ItemStack((Item)this.lastType.getPartItem());
                        JewelryHelper.setMaterial(itemStack, material);
                        this.inventory.setStackInSlot(2, itemStack);
                    }
                }
            }
        }
    }

    public void writeNBT(NBTTagCompound dataTag) {
        dataTag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        dataTag.func_74768_a("fuel", this.fuel);
        dataTag.func_74768_a("fuelTotal", this.fuelTotal);
        dataTag.func_74768_a("progress", this.progress);
        dataTag.func_74757_a("processing", this.processing);
        if (this.getLastType() != null) {
            dataTag.func_74778_a("lastPart", this.getLastType().getRegistryName().toString());
        }
    }

    public void readNBT(NBTTagCompound dataTag) {
        this.inventory.deserializeNBT(dataTag.func_74775_l("inventory"));
        this.fuelTotal = dataTag.func_74762_e("fuelTotal");
        this.progress = dataTag.func_74762_e("progress");
        this.processing = dataTag.func_74767_n("processing");
        this.lastType = JewelryHelper.getPartTypeByName(dataTag.func_74779_i("lastPart"));
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public int getFuelTotal() {
        return this.fuelTotal;
    }

    public void setFuelTotal(int fuelTotal) {
        this.fuelTotal = fuelTotal;
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressMax() {
        return this.progressMax;
    }

    public PartType getLastType() {
        return this.lastType;
    }

    public void setLastPart(PartType lastType) {
        this.lastType = lastType;
    }

    public void setProcessing(boolean processing) {
        this.processing = processing;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setLastType(PartType lastType) {
        this.lastType = lastType;
    }
}

