/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct.item;

import com.jarhax.jewelersconstruct.JewelersConstruct;
import com.jarhax.jewelersconstruct.api.JewelryHelper;
import com.jarhax.jewelersconstruct.api.material.Material;
import com.jarhax.jewelersconstruct.api.part.PartType;
import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.item.IColorfulItem;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPart
extends Item
implements IColorfulItem {
    private final PartType type;

    public ItemPart(PartType type) {
        this.type = type;
        this.func_77625_d(1);
        this.field_77787_bX = true;
        type.setPartItem(this);
    }

    public PartType getPartType() {
        return this.type;
    }

    public String func_77653_i(ItemStack stack) {
        return JewelryHelper.getMaterialName(JewelryHelper.getPartMaterial(stack)) + " " + JewelersConstruct.PROXY.translate(this.getPartType().getTranslationName(), new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(JewelryHelper.getMaterialName(JewelryHelper.getPartMaterial(stack)));
        tooltip.add("Modifier count: " + JewelryHelper.getPartMaterial(stack).getRetention());
        tooltip.add("Durability modifier: " + JewelryHelper.getPartMaterial(stack).getDurability());
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Material material : JewelryHelper.MATERIALS) {
                if (!material.isValidForPart(this.getPartType()) || !this.getPartType().isValidForMaterial(material)) continue;
                ItemStack stack = new ItemStack((Item)this);
                JewelryHelper.setMaterial(stack, material);
                items.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IItemColor getColorHandler() {
        return (stack, layer) -> {
            Material material = JewelryHelper.getPartMaterial(stack);
            return material != null ? material.getColor(stack, layer) : 0;
        };
    }
}

