/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.jarhax.jewelersconstruct.JewelersConstruct;
import com.jarhax.jewelersconstruct.TempUtils;
import com.jarhax.jewelersconstruct.api.JewelryHelper;
import com.jarhax.jewelersconstruct.api.material.Material;
import com.jarhax.jewelersconstruct.api.modifier.Modifier;
import com.jarhax.jewelersconstruct.api.trinket.TrinketType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.util.PlayerUtils;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemJewelry
extends Item
implements IBauble {
    private static final String TAG_LAST_PLAYER = "LastPlayer";
    private final TrinketType partTypes;
    private final BaubleType baubleType;

    public ItemJewelry(TrinketType type, BaubleType baubleType) {
        this.func_77625_d(1);
        this.partTypes = type;
        this.partTypes.setTrinketItem(this);
        this.baubleType = baubleType;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
        if (stack.func_77952_i() > stack.func_77958_k()) {
            super.setDamage(stack, stack.func_77958_k());
        }
    }

    public int getMaxDamage(ItemStack stack) {
        boolean baseDurability = true;
        int durability = 0;
        durability = JewelryHelper.getJewelryMaterials(stack).stream().mapToInt(Material::getDurability).sum();
        for (Map.Entry<Modifier, Integer> modifierData : JewelryHelper.getModifiers(stack).entrySet()) {
            durability += modifierData.getKey().getModifiedDurability(stack, modifierData.getValue(), 1);
        }
        return durability;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return this.baubleType;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (player instanceof EntityPlayer) {
            if (!ItemJewelry.isLastUser(stack, player)) {
                this.onEquipped(stack, player);
            }
            JewelryHelper.tickJewelry(stack, (EntityPlayer)player);
        }
    }

    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        if (player instanceof EntityPlayer) {
            JewelryHelper.updatePlayerModifiers((EntityPlayer)player);
            ItemJewelry.setLastUser(stack, player);
        }
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        if (player instanceof EntityPlayer) {
            JewelryHelper.updatePlayerModifiers((EntityPlayer)player);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Modifier modifier : JewelryHelper.MODIFIERS) {
                for (int level = 1; level <= modifier.getMaxLevel(); ++level) {
                    ItemStack stack = new ItemStack((Item)this);
                    JewelryHelper.setModifier(stack, modifier, level);
                    items.add((Object)stack);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        List<Material> materials = JewelryHelper.getJewelryMaterials(stack);
        if (materials.isEmpty()) {
            tooltip.add(JewelersConstruct.PROXY.translate("jewelersconstruct.material.missing", new Object[0]));
        } else {
            for (Material material : materials) {
                tooltip.add(JewelersConstruct.PROXY.translate(material.getTranslationName(), new Object[0]));
            }
        }
        Set<Map.Entry<Modifier, Integer>> modifiers = JewelryHelper.getModifiers(stack).entrySet();
        if (modifiers.isEmpty()) {
            tooltip.add(JewelersConstruct.PROXY.translate("jewelersconstruct.modifier.missing", new Object[0]));
        } else {
            for (Map.Entry<Modifier, Integer> entry : modifiers) {
                tooltip.add(JewelersConstruct.PROXY.translate(entry.getKey().getTranslationName(), new Object[0]) + " " + JewelersConstruct.PROXY.translate("enchantment.level." + entry.getValue(), new Object[0]));
                TempUtils.getModifierTooltip(entry.getKey().getAttributeModifiers(stack, (EntityLivingBase)PlayerUtils.getClientPlayer(), entry.getValue()), tooltip);
            }
        }
        tooltip.add("Durability: " + this.getMaxDamage(stack));
        if (flagIn == ITooltipFlag.TooltipFlags.ADVANCED) {
            int n = JewelryHelper.getModifierCount(stack);
            int n2 = JewelryHelper.getRetention(stack);
            tooltip.add((n > n2 ? TextFormatting.RED.toString() : TextFormatting.GRAY) + JewelersConstruct.PROXY.translate("tooltip.jewelersconstruct.modifiercout", n, n2));
        }
    }

    private static void setLastUser(ItemStack stack, EntityLivingBase user) {
        StackUtils.prepareStackTag((ItemStack)stack).func_186854_a(TAG_LAST_PLAYER, user.func_110124_au());
    }

    private static boolean isLastUser(ItemStack stack, EntityLivingBase user) {
        return stack.func_77942_o() ? stack.func_77978_p().func_186857_a(TAG_LAST_PLAYER).equals(user.func_110124_au()) : false;
    }
}

