/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct.item;

import com.jarhax.jewelersconstruct.JewelersConstruct;
import com.jarhax.jewelersconstruct.TempUtils;
import com.jarhax.jewelersconstruct.api.JewelryHelper;
import com.jarhax.jewelersconstruct.api.modifier.Modifier;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.item.IColorfulItem;
import net.darkhax.bookshelf.util.PlayerUtils;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCreativeModifier
extends Item
implements IColorfulItem {
    public ItemCreativeModifier() {
        this.func_77625_d(1);
        this.field_77787_bX = true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Modifier modifier : JewelryHelper.MODIFIERS) {
                for (int level = 1; level <= modifier.getMaxLevel(); ++level) {
                    ItemStack stack = new ItemStack((Item)this);
                    JewelryHelper.setModifier(stack, modifier, level);
                    items.add((Object)stack);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Set<Map.Entry<Modifier, Integer>> modifiers = JewelryHelper.getModifiers(stack).entrySet();
        if (modifiers.isEmpty()) {
            tooltip.add(JewelersConstruct.PROXY.translate("jewelersconstruct.modifier.missing", new Object[0]));
        } else {
            for (Map.Entry<Modifier, Integer> modifierData : modifiers) {
                tooltip.add(JewelersConstruct.PROXY.translate(modifierData.getKey().getTranslationName(), new Object[0]) + " " + JewelersConstruct.PROXY.translate("enchantment.level." + modifierData.getValue(), new Object[0]));
                TempUtils.getModifierTooltip(modifierData.getKey().getAttributeModifiers(stack, (EntityLivingBase)PlayerUtils.getClientPlayer(), modifierData.getValue()), tooltip);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IItemColor getColorHandler() {
        return (stack, layer) -> {
            Map<Modifier, Integer> modifiers = JewelryHelper.getModifiers(stack);
            int color = 0;
            for (Map.Entry<Modifier, Integer> entry : modifiers.entrySet()) {
                Color awtColor = new Color(entry.getKey().getRegistryName().func_110623_a().hashCode());
                for (int level = 1; level != entry.getValue(); ++level) {
                    awtColor = TempUtils.darkenColor(awtColor, 0.86);
                }
                color += awtColor.getRGB();
            }
            return color;
        };
    }
}

