/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct.client.gui;

import com.jarhax.jewelersconstruct.JewelersConstruct;
import com.jarhax.jewelersconstruct.api.JewelryHelper;
import com.jarhax.jewelersconstruct.api.material.Material;
import com.jarhax.jewelersconstruct.api.part.PartType;
import com.jarhax.jewelersconstruct.client.container.ContainerPartShaper;
import com.jarhax.jewelersconstruct.client.gui.buttons.GuiButtonPart;
import com.jarhax.jewelersconstruct.client.gui.buttons.GuiButtonShape;
import com.jarhax.jewelersconstruct.network.PacketStartPartShape;
import com.jarhax.jewelersconstruct.network.PacketSyncPartShape;
import com.jarhax.jewelersconstruct.tileentities.TileEntityPartShaper;
import java.io.IOException;
import java.util.Random;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;
import org.lwjgl.opengl.GL11;

public class GuiPartShaper
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("jewelersconstruct", "textures/gui/gui_part_shaper.png");
    private int left;
    private int top;
    private final TileEntityPartShaper tile;

    public GuiPartShaper(InventoryPlayer invPlayer, TileEntityPartShaper tile) {
        super((Container)new ContainerPartShaper(invPlayer, tile));
        this.tile = tile;
    }

    public void func_73866_w_() {
        this.field_146999_f = 276;
        this.field_147000_g = 166;
        super.func_73866_w_();
        this.left = this.field_146294_l / 2 - this.field_146999_f / 2;
        this.top = this.field_146295_m / 2 - this.field_147000_g / 2;
        int index = 0;
        int indexX = 0;
        int indexY = 0;
        this.field_146292_n.add(new GuiButtonShape(index++, this.left + 108, this.top + 17 + 17, 40, 20, "shape"));
        for (PartType type : JewelryHelper.PART_TYPES.getValuesCollection()) {
            GuiButtonPart buttonPart = new GuiButtonPart(this, index++, this.left + 100 - 25 - 25 * indexX++, this.top + 25 * indexY, 20, 20, type, new Random().nextInt() * 0xFFFFFF);
            if (((Object)((Object)this.tile.getLastType())).equals((Object)type)) {
                buttonPart.setSelected(true);
            }
            this.field_146292_n.add(buttonPart);
            if (indexX <= 2) continue;
            ++indexY;
            indexX = 0;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int width;
        super.func_146979_b(mouseX, mouseY);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        GL11.glPushMatrix();
        int height = (int)((float)this.tile.getFuel() / (float)this.tile.getFuelTotal() * 13.0f);
        if (height > 0) {
            this.func_73729_b(156, 49 - height, this.field_146999_f - 100, 28 - height, 14, 14);
        }
        if ((width = (int)((float)this.tile.getProgress() / (float)this.tile.getProgressMax() * 23.0f)) > 0) {
            this.func_73729_b(180, 34, this.field_146999_f - 100 + 1, 0, width, 16);
        }
        GL11.glPopMatrix();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.left + 100, this.top, 0, 0, this.field_146999_f - 100, 166);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        ItemStackHandler inv;
        super.func_146284_a(button);
        if (button instanceof GuiButtonPart) {
            if (!this.tile.isProcessing()) {
                this.tile.setLastPart(((GuiButtonPart)button).getType());
                JewelersConstruct.NETWORK.sendToServer((IMessage)new PacketSyncPartShape(this.tile.func_174877_v(), ((GuiButtonPart)button).getType()));
                for (GuiButton butt : this.field_146292_n) {
                    if (!(butt instanceof GuiButtonPart)) continue;
                    ((GuiButtonPart)butt).setSelected(false);
                }
                ((GuiButtonPart)button).setSelected(true);
            }
        } else if (button instanceof GuiButtonShape && !(inv = this.tile.getInventory()).getStackInSlot(0).func_190926_b() && inv.getStackInSlot(2).func_190926_b()) {
            Material material = JewelryHelper.getMaterial(inv.getStackInSlot(0));
            System.out.println((Object)material);
            System.out.println(material.isValidForPart(this.tile.getLastType()));
            if (material.isValidForPart(this.tile.getLastType())) {
                if (!this.tile.isProcessing()) {
                    this.tile.setProgress(0);
                }
                this.tile.setProcessing(true);
                JewelersConstruct.NETWORK.sendToServer((IMessage)new PacketStartPartShape(this.tile.func_174877_v(), true));
            }
        }
    }
}

