/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct.api.modifier;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.jarhax.jewelersconstruct.TempUtils;
import com.jarhax.jewelersconstruct.api.modifier.ModifierBase;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.darkhax.bookshelf.data.AttributeOperation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ModifierAttribute
extends ModifierBase {
    private final List<Multimap<String, AttributeModifier>> modifiers = new ArrayList<Multimap<String, AttributeModifier>>();
    private final int maxLevel;

    public ModifierAttribute(String name, IAttribute attribute, double amount, AttributeOperation operation, String uuid) {
        this(name, attribute, amount, operation, 1, uuid);
    }

    public ModifierAttribute(String name, IAttribute attribute, double amount, AttributeOperation operation, int maxLevel, String uuid) {
        super(TempUtils.getIdForActiveMod(name));
        ResourceLocation location = this.getRegistryName();
        for (int i = 1; i <= maxLevel; ++i) {
            HashMultimap levelModifiers = HashMultimap.create();
            levelModifiers.put((Object)attribute.func_111108_a(), (Object)new AttributeModifier(UUID.fromString(uuid), location.func_110624_b() + "_" + location.func_110623_a(), amount * (double)i, operation.ordinal()));
            this.modifiers.add((Multimap<String, AttributeModifier>)levelModifiers);
        }
        this.maxLevel = maxLevel;
    }

    @Override
    public void onWearerTick(ItemStack stack, EntityLivingBase user, int level) {
        if (!user.field_70170_p.field_72995_K && user.field_70173_aa % 600 == 0) {
            stack.func_77972_a(1, user);
        }
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack, EntityLivingBase wearer, int level) {
        return this.modifiers.get(this.getLevelInRange(level) - 1);
    }
}

