/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct.api;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.jarhax.jewelersconstruct.JewelersConstruct;
import com.jarhax.jewelersconstruct.api.material.Material;
import com.jarhax.jewelersconstruct.api.modifier.Modifier;
import com.jarhax.jewelersconstruct.api.part.PartType;
import com.jarhax.jewelersconstruct.api.trinket.TrinketType;
import com.jarhax.jewelersconstruct.item.ItemJewelry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.lib.ItemStackMap;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class JewelryHelper {
    public static final IForgeRegistry<Modifier> MODIFIERS = GameRegistry.findRegistry(Modifier.class);
    public static final IForgeRegistry<Material> MATERIALS = GameRegistry.findRegistry(Material.class);
    public static final IForgeRegistry<PartType> PART_TYPES = GameRegistry.findRegistry(PartType.class);
    public static final IForgeRegistry<TrinketType> TRINKET_TYPES = GameRegistry.findRegistry(TrinketType.class);
    public static final ItemStackMap<Material> INPUTS_TO_MATERIALS = new ItemStackMap(ItemStackMap.SIMILAR);
    public static final ItemStackMap<Modifier> INPUTS_TO_MODIFIERS = new ItemStackMap(ItemStackMap.SIMILAR);
    private static final String TAG_MODIFIERS = "Modifiers";
    private static final String TAG_MODIFIER = "Modifier";
    private static final String TAG_LEVEL = "ModifierLevel";
    private static final String TAG_MATERIAL = "Material";
    private static final String TAG_MATERIALS = "Materials";

    public static Modifier getModifierByName(String name) {
        return (Modifier)MODIFIERS.getValue(new ResourceLocation(name));
    }

    public static Material getMaterialByName(String name) {
        return (Material)MATERIALS.getValue(new ResourceLocation(name));
    }

    public static PartType getPartTypeByName(String name) {
        return (PartType)PART_TYPES.getValue(new ResourceLocation(name));
    }

    public static TrinketType getTrinketTypeByName(String name) {
        return (TrinketType)TRINKET_TYPES.getValue(new ResourceLocation(name));
    }

    public static void tickJewelry(ItemStack stack, EntityPlayer user) {
        if (!JewelryHelper.isBroken(stack)) {
            for (Map.Entry<Modifier, Integer> modifierData : JewelryHelper.getModifiers(stack).entrySet()) {
                modifierData.getKey().onWearerTick(stack, (EntityLivingBase)user, modifierData.getValue());
            }
        } else {
            JewelryHelper.updatePlayerModifiers(user);
        }
    }

    public static void updatePlayerModifiers(EntityPlayer player) {
        JewelryHelper.removeAllModifiers(player);
        for (Map.Entry<Modifier, Tuple<ItemStack, Integer>> topModifiers : JewelryHelper.getHighestModifiers(player).entrySet()) {
            player.func_110140_aT().func_111147_b(topModifiers.getKey().getAttributeModifiers((ItemStack)topModifiers.getValue().func_76341_a(), (EntityLivingBase)player, (Integer)topModifiers.getValue().func_76340_b()));
        }
    }

    public static void removeAllModifiers(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slot = 0; slot < baubles.getSlots(); ++slot) {
            ItemStack stack = baubles.getStackInSlot(slot);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemJewelry)) continue;
            for (Map.Entry<Modifier, Integer> modifierData : JewelryHelper.getModifiers(stack).entrySet()) {
                player.func_110140_aT().func_111148_a(modifierData.getKey().getAttributeModifiers(stack, (EntityLivingBase)player, modifierData.getValue()));
            }
        }
    }

    public static Map<Modifier, Tuple<ItemStack, Integer>> getHighestModifiers(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        HashMap previousBest = new HashMap();
        HashMap<Modifier, Tuple<ItemStack, Integer>> results = new HashMap<Modifier, Tuple<ItemStack, Integer>>();
        for (int slot = 0; slot < baubles.getSlots(); ++slot) {
            ItemStack stack = baubles.getStackInSlot(slot);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemJewelry) || JewelryHelper.isBroken(stack)) continue;
            for (Map.Entry<Modifier, Integer> modifierData : JewelryHelper.getModifiers(stack).entrySet()) {
                Modifier modifier = modifierData.getKey();
                if (previousBest.containsKey((Object)modifier) && (Integer)previousBest.get((Object)modifier) >= modifierData.getValue()) continue;
                results.put(modifier, (Tuple<ItemStack, Integer>)new Tuple((Object)stack, (Object)modifierData.getValue()));
            }
        }
        return results;
    }

    public static void removeModifier(ItemStack stack, Modifier modifier) {
        Map<Modifier, Integer> modifiers = JewelryHelper.getModifiers(stack);
        modifiers.remove((Object)modifier);
        JewelryHelper.setModifiers(stack, modifiers);
    }

    public static void setModifier(ItemStack stack, Modifier modifier, int level) {
        Map<Modifier, Integer> modifiers = JewelryHelper.getModifiers(stack);
        modifiers.put(modifier, level);
        JewelryHelper.setModifiers(stack, modifiers);
    }

    public static Map<Modifier, Integer> getModifiers(ItemStack stack) {
        HashMap<Modifier, Integer> modifiers = new HashMap<Modifier, Integer>();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(TAG_MODIFIERS)) {
            NBTTagList list = stack.func_77978_p().func_150295_c(TAG_MODIFIERS, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                Modifier modifier = JewelryHelper.getModifierByName(tag.func_74779_i(TAG_MODIFIER));
                if (modifier == null) continue;
                modifiers.put(modifier, tag.func_74762_e(TAG_LEVEL));
            }
        }
        return modifiers;
    }

    public static void setModifiers(ItemStack stack, Map<Modifier, Integer> modifiers) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Modifier, Integer> modifierData : modifiers.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a(TAG_MODIFIER, modifierData.getKey().getRegistryName().toString());
            tag.func_74768_a(TAG_LEVEL, modifierData.getValue().intValue());
            list.func_74742_a((NBTBase)tag);
        }
        StackUtils.prepareStackTag((ItemStack)stack).func_74782_a(TAG_MODIFIERS, (NBTBase)list);
    }

    public static int getModifierCount(ItemStack stack) {
        int count = 0;
        for (Map.Entry<Modifier, Integer> modifierData : JewelryHelper.getModifiers(stack).entrySet()) {
            if (!modifierData.getKey().countsTowardsLimit(stack, modifierData.getValue())) continue;
            count += modifierData.getValue().intValue();
        }
        return count;
    }

    public static Material getPartMaterial(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b(TAG_MATERIAL) ? JewelryHelper.getMaterialByName(tag.func_74779_i(TAG_MATERIAL)) : null;
    }

    public static void setMaterial(ItemStack stack, Material material) {
        StackUtils.prepareStackTag((ItemStack)stack).func_74778_a(TAG_MATERIAL, material.getRegistryName().toString());
    }

    @SideOnly(value=Side.CLIENT)
    public static String getMaterialName(Material material) {
        String translationKey = material != null ? material.getTranslationName() : "jewelersconstruct.material.undefined";
        return JewelersConstruct.PROXY.translate(translationKey, new Object[0]);
    }

    public static void associateMaterial(Item item, Material material) {
        JewelryHelper.associateMaterial(new ItemStack(item), material);
    }

    public static void associateMaterial(String oredict, Material material) {
        for (ItemStack stack : OreDictionary.getOres((String)oredict)) {
            System.out.println("Associating material " + stack.toString() + oredict);
            JewelryHelper.associateMaterial(stack, material);
        }
    }

    public static void associateMaterial(ItemStack stack, Material material) {
        INPUTS_TO_MATERIALS.put((Object)stack, (Object)material);
    }

    public static void associateModifier(String oredict, Modifier material) {
        for (ItemStack stack : OreDictionary.getOres((String)oredict)) {
            System.out.println("Associating modifier" + stack.toString() + oredict);
            JewelryHelper.associateModifier(stack, material);
        }
    }

    public static void associateModifier(ItemStack stack, Modifier modifier) {
        INPUTS_TO_MODIFIERS.put((Object)stack, (Object)modifier);
    }

    public static Material getMaterial(ItemStack stack) {
        return (Material)((Object)INPUTS_TO_MATERIALS.get((Object)stack));
    }

    public static ItemStack setJewelryMaterials(ItemStack stack, Collection<Material> materials) {
        NBTTagCompound tag = StackUtils.prepareStackTag((ItemStack)stack);
        NBTTagList matList = new NBTTagList();
        for (Material material : materials) {
            matList.func_74742_a((NBTBase)new NBTTagString(material.getRegistryName().toString()));
        }
        tag.func_74782_a(TAG_MATERIALS, (NBTBase)matList);
        return stack;
    }

    public static void setJewelryMaterials(ItemStack stack, Material ... materials) {
        NBTTagCompound tag = StackUtils.prepareStackTag((ItemStack)stack);
        NBTTagList matList = new NBTTagList();
        for (Material material : materials) {
            matList.func_74742_a((NBTBase)new NBTTagString(material.getRegistryName().toString()));
        }
        tag.func_74782_a(TAG_MATERIALS, (NBTBase)matList);
    }

    public static List<Material> getJewelryMaterials(ItemStack stack) {
        ArrayList<Material> materials = new ArrayList<Material>();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(TAG_MATERIALS)) {
            NBTTagList matList = stack.func_77978_p().func_150295_c(TAG_MATERIALS, 8);
            for (int i = 0; i < matList.func_74745_c(); ++i) {
                Material mat = JewelryHelper.getMaterialByName(matList.func_150307_f(i));
                if (mat == null) continue;
                materials.add(mat);
            }
        }
        return materials;
    }

    public static List<Material> getValidMaterials(PartType partType) {
        ArrayList<Material> validMaterials = new ArrayList<Material>();
        for (Material mat : MATERIALS) {
            if (!partType.isValidForMaterial(mat) || !mat.isValidForPart(partType)) continue;
            validMaterials.add(mat);
        }
        return validMaterials;
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i() <= 0;
    }

    public static int getRetention(ItemStack stack) {
        return JewelryHelper.getJewelryMaterials(stack).stream().mapToInt(Material::getRetention).sum();
    }
}

