/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct;

import com.google.common.collect.Multimap;
import com.jarhax.jewelersconstruct.JewelersConstruct;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.darkhax.bookshelf.util.StackUtils;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.OreDictionary;

public class TempUtils {
    public static boolean equalForCrafting(ItemStack stack, Object recipeStack) {
        if (recipeStack instanceof ItemStack) {
            return TempUtils.areStacksSimilarWithSize(stack, (ItemStack)recipeStack);
        }
        if (recipeStack instanceof String) {
            return TempUtils.getOreNames(stack).contains(recipeStack);
        }
        return false;
    }

    public static boolean areStacksSimilarWithSize(ItemStack firstStack, ItemStack secondStack) {
        return StackUtils.areStacksSimilar((ItemStack)firstStack, (ItemStack)secondStack) && firstStack.func_190916_E() >= secondStack.func_190916_E();
    }

    public static Set<String> getOreNames(ItemStack stack) {
        HashSet<String> names = new HashSet<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            names.add(OreDictionary.getOreName((int)id));
        }
        return names;
    }

    public static ResourceLocation getIdForActiveMod(String name) {
        ModContainer container;
        if (!name.contains(":") && (container = Loader.instance().activeModContainer()) != null) {
            return new ResourceLocation(container.getModId(), name);
        }
        return new ResourceLocation(name);
    }

    public static void getModifierTooltip(Multimap<String, AttributeModifier> multimap, List<String> list) {
        if (!multimap.isEmpty()) {
            for (Map.Entry entry : multimap.entries()) {
                double displayAmount;
                AttributeModifier modifier = (AttributeModifier)entry.getValue();
                double baseAmount = modifier.func_111164_d();
                double d = displayAmount = modifier.func_111169_c() != 1 && modifier.func_111169_c() != 2 ? baseAmount : baseAmount * 100.0;
                if (baseAmount > 0.0) {
                    list.add(TextFormatting.BLUE + " " + JewelersConstruct.PROXY.translate("attribute.modifier.plus." + modifier.func_111169_c(), ItemStack.field_111284_a.format(displayAmount), JewelersConstruct.PROXY.translate("attribute.name." + (String)entry.getKey(), new Object[0])));
                    continue;
                }
                if (!(baseAmount < 0.0)) continue;
                list.add(TextFormatting.RED + " " + JewelersConstruct.PROXY.translate("attribute.modifier.take." + modifier.func_111169_c(), ItemStack.field_111284_a.format(displayAmount *= -1.0), JewelersConstruct.PROXY.translate("attribute.name." + (String)entry.getKey(), new Object[0])));
            }
        }
    }

    public static Color darkenColor(Color awtColor, double factor) {
        return new Color(Math.max((int)((double)awtColor.getRed() * factor), 0), Math.max((int)((double)awtColor.getGreen() * factor), 0), Math.max((int)((double)awtColor.getBlue() * factor), 0), awtColor.getAlpha());
    }

    public static <T> Set<List<T>> getCombinations(List<List<T>> lists) {
        HashSet<List<Object>> combinations = new HashSet<List<T>>();
        int index = 0;
        for (T i : lists.get(0)) {
            ArrayList<T> arrayList = new ArrayList<T>();
            arrayList.add(i);
            combinations.add(arrayList);
        }
        ++index;
        while (index < lists.size()) {
            List<T> nextList = lists.get(index);
            HashSet newCombinations = new HashSet();
            for (List list : combinations) {
                for (T second : nextList) {
                    ArrayList<T> newList = new ArrayList<T>();
                    newList.addAll(list);
                    newList.add(second);
                    newCombinations.add(newList);
                }
            }
            combinations = newCombinations;
            ++index;
        }
        return combinations;
    }
}

