/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct;

import com.google.common.collect.Multimap;
import com.jarhax.jewelersconstruct.Content;
import com.jarhax.jewelersconstruct.CreativeTabJewelersConstruct;
import com.jarhax.jewelersconstruct.addons.tcon.AddonManager;
import com.jarhax.jewelersconstruct.api.JewelryHelper;
import com.jarhax.jewelersconstruct.api.material.Material;
import com.jarhax.jewelersconstruct.api.modifier.Modifier;
import com.jarhax.jewelersconstruct.api.part.PartType;
import com.jarhax.jewelersconstruct.api.trinket.TrinketType;
import com.jarhax.jewelersconstruct.client.gui.GuiHandler;
import com.jarhax.jewelersconstruct.network.PacketStartPartShape;
import com.jarhax.jewelersconstruct.network.PacketSyncPartShape;
import com.jarhax.jewelersconstruct.network.PacketSyncTrinketForge;
import com.jarhax.jewelersconstruct.proxy.CommonProxy;
import net.darkhax.bookshelf.network.NetworkHandler;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.bookshelf.util.ModUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="jewelersconstruct", name="Jewelers Construct", version="@VERSION@", acceptedMinecraftVersions="[1.12.2]")
public class JewelersConstruct {
    public static final String MOD_ID = "jewelersconstruct";
    public static final Logger LOG = LogManager.getLogger((String)"Jewelers Construct");
    public static final RegistryHelper REGISTRY = new RegistryHelper().setTab((CreativeTabs)new CreativeTabJewelersConstruct()).enableAutoRegistration();
    @SidedProxy(clientSide="com.jarhax.jewelersconstruct.proxy.ClientProxy", serverSide="com.jarhax.jewelersconstruct.proxy.CommonProxy")
    public static CommonProxy PROXY;
    @Mod.Instance(value="jewelersconstruct")
    public static JewelersConstruct INSTANCE;
    public static final NetworkHandler NETWORK;

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        AddonManager.init(event.getASMHarvestedData());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        NETWORK.register(PacketSyncPartShape.class, Side.SERVER);
        NETWORK.register(PacketStartPartShape.class, Side.SERVER);
        NETWORK.register(PacketSyncTrinketForge.class, Side.SERVER);
        LOG.info("Creating registries!");
        JewelersConstruct.createForgeRegistry("modifiers", Modifier.class);
        JewelersConstruct.createForgeRegistry("materials", Material.class);
        JewelersConstruct.createForgeRegistry("part_types", PartType.class);
        JewelersConstruct.createForgeRegistry("trinket_types", TrinketType.class);
        LOG.info("Registries created!");
        Content.registerBlocks(REGISTRY);
        Content.registerItems(REGISTRY);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        PROXY.registerRenders();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        JewelersConstruct.logRegistry("modifier", JewelryHelper.MODIFIERS);
        JewelersConstruct.logRegistry("material", JewelryHelper.MATERIALS);
        JewelersConstruct.logRegistry("part type", JewelryHelper.PART_TYPES);
        JewelersConstruct.logRegistry("trinket type", JewelryHelper.TRINKET_TYPES);
        Content.associateItemsToMaterial();
    }

    private static void logRegistry(String name, IForgeRegistry<?> registry) {
        Multimap sorted = ModUtils.getSortedEntries(registry);
        LOG.info("The {} registry loaded with {} entries from {} mod(s).", (Object)name, (Object)sorted.values().size(), (Object)sorted.keySet().size());
    }

    private static <T extends IForgeRegistryEntry<T>> IForgeRegistry<T> createForgeRegistry(String name, Class<T> type) {
        return new RegistryBuilder().setName(new ResourceLocation(MOD_ID, name)).setType(type).setMaxID(0x3FFFFFF).create();
    }

    static {
        NETWORK = new NetworkHandler(MOD_ID);
    }
}

