/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.jewelersconstruct;

import baubles.api.BaubleType;
import com.jarhax.jewelersconstruct.JewelersConstruct;
import com.jarhax.jewelersconstruct.TempUtils;
import com.jarhax.jewelersconstruct.addons.tcon.AddonManager;
import com.jarhax.jewelersconstruct.api.JewelryHelper;
import com.jarhax.jewelersconstruct.api.material.Material;
import com.jarhax.jewelersconstruct.api.material.MaterialBase;
import com.jarhax.jewelersconstruct.api.material.MaterialGem;
import com.jarhax.jewelersconstruct.api.modifier.Modifier;
import com.jarhax.jewelersconstruct.api.modifier.ModifierAttribute;
import com.jarhax.jewelersconstruct.api.part.PartType;
import com.jarhax.jewelersconstruct.api.part.PartTypeBase;
import com.jarhax.jewelersconstruct.api.part.PartTypeGem;
import com.jarhax.jewelersconstruct.api.trinket.TrinketType;
import com.jarhax.jewelersconstruct.api.trinket.TrinketTypeBase;
import com.jarhax.jewelersconstruct.blocks.BlockPartForge;
import com.jarhax.jewelersconstruct.blocks.BlockPartShaper;
import com.jarhax.jewelersconstruct.item.ItemCreativeModifier;
import com.jarhax.jewelersconstruct.item.ItemJewelry;
import com.jarhax.jewelersconstruct.item.ItemPart;
import com.jarhax.jewelersconstruct.modifiers.ModifierFloat;
import com.jarhax.jewelersconstruct.modifiers.ModifierFood;
import com.jarhax.jewelersconstruct.modifiers.ModifierMagnet;
import com.jarhax.jewelersconstruct.modifiers.ModifierSaturation;
import com.jarhax.jewelersconstruct.modifiers.ModifierStepUp;
import com.jarhax.jewelersconstruct.tileentities.TileEntityPartShaper;
import com.jarhax.jewelersconstruct.tileentities.TileEntityTrinketForge;
import net.darkhax.bookshelf.data.AttributeOperation;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class Content {
    public static final Modifier MODIFIER_VIGOR = new ModifierAttribute("vigor", SharedMonsterAttributes.field_111264_e, 1.5, AttributeOperation.ADDITIVE, 5, "a9106b47-1153-4620-831e-38cb01a63fec");
    public static final Modifier MODIFIER_VITALITY = new ModifierAttribute("vitality", SharedMonsterAttributes.field_111267_a, 2.0, AttributeOperation.ADDITIVE, 5, "83ba3ce9-c4c5-472f-b9da-f79422e7d711");
    public static final Modifier MODIFIER_FORTITUDE = new ModifierAttribute("fortitude", SharedMonsterAttributes.field_188791_g, 2.0, AttributeOperation.ADDITIVE, 3, "00dc5641-1c03-4aa6-940c-d4195ca49d44c");
    public static final Modifier MODIFIER_STURDY = new ModifierAttribute("sturdy", SharedMonsterAttributes.field_111266_c, 0.05, AttributeOperation.MULTIPLY_SEPERATE, 3, "d770af89-3ec9-40f0-b36c-cbc67242adec");
    public static final Modifier MODIFIER_LUCK = new ModifierAttribute("luck", SharedMonsterAttributes.field_188792_h, 1.0, AttributeOperation.ADDITIVE, 3, "142f0767-4c33-4afc-9d74-8990230b9ec7");
    public static final Modifier MODIFIER_GRASPING = new ModifierAttribute("grasping", EntityPlayer.REACH_DISTANCE, 1.25, AttributeOperation.ADDITIVE, 3, "15b13705-586d-4b25-9fbf-7dc76613977b");
    public static final Modifier MODIFIER_SWIFT = new ModifierAttribute("swift", SharedMonsterAttributes.field_188790_f, 0.33, AttributeOperation.ADDITIVE, 3, "0238fcd1-c252-4389-9022-06215adff31f");
    public static final Modifier MODIFIER_TRAVELER = new ModifierAttribute("traveler", SharedMonsterAttributes.field_111263_d, 0.1, AttributeOperation.MULTIPLY, 5, "7a87405c-f8e8-4ba7-a235-fd6c0e90ebd2");
    public static final Modifier MODIFIER_STEP_UP = new ModifierStepUp();
    public static final Modifier MODIFIER_FLOAT = new ModifierFloat();
    public static final Modifier MODIFIER_FOOD = new ModifierFood();
    public static final Modifier MODIFIER_SATURATION = new ModifierSaturation();
    public static final Modifier MODIFIER_MAGNET = new ModifierMagnet();
    public static final Material MATERIAL_WOOD = new MaterialBase(60, 1, 1, "wood", 7690273);
    public static final Material MATERIAL_FLINT = new MaterialBase(70, 1, 2, "flint", 0x696969);
    public static final Material MATERIAL_BONE = new MaterialBase(80, 1, 1, "bone", 15591103);
    public static final Material MATERIAL_STONE = new MaterialBase(120, 1, 1, "stone", 0x959595);
    public static final Material MATERIAL_IRON = new MaterialBase(256, 1, 1, "iron", 0xFFFFFF);
    public static final Material MATERIAL_GOLD = new MaterialBase(60, 3, 2, "gold", 13286716);
    public static final Material MATERIAL_PRISMARINE = new MaterialGem(30, 0, 0, "Prismarine", 9945268);
    public static final Material MATERIAL_EMERALD = new MaterialGem(45, 0, 0, "Emerald", 3524453);
    public static final Material MATERIAL_DIAMOND = new MaterialGem(80, 0, 0, "Diamond", 7657927);
    public static final Material MATERIAL_COPPER = new MaterialBase(260, 1, 1, "copper", 15572743);
    public static final Material MATERIAL_BRONZE = new MaterialBase(350, 1, 1, "bronze", 14925160);
    public static final Material MATERIAL_LEAD = new MaterialBase(355, 1, 1, "lead", 5065064);
    public static final Material MATERIAL_SILVER = new MaterialBase(300, 2, 3, "silver", 13757686);
    public static final Material MATERIAL_ELECTRUM = new MaterialBase(285, 3, 3, "electrum", 15260489);
    public static final Material MATERIAL_STEEL = new MaterialBase(500, 1, 1, "steel", 0xA7A7A7);
    public static final PartType PART_BAND = new PartTypeBase("band", new ResourceLocation("jewelersconstruct", "textures/items/part_band.png"));
    public static final PartType PART_BINDING = new PartTypeBase("binding", new ResourceLocation("jewelersconstruct", "textures/items/part_binding.png"));
    public static final PartType PART_CHAIN = new PartTypeBase("chain", new ResourceLocation("jewelersconstruct", "textures/items/part_chain.png"));
    public static final PartType PART_BUCKLE = new PartTypeBase("buckle", new ResourceLocation("jewelersconstruct", "textures/items/part_buckle.png"));
    public static final PartType PART_GEM = new PartTypeGem("gem", new ResourceLocation("jewelersconstruct", "textures/items/part_gem.png"));
    public static final TrinketType TYPE_RING = new TrinketTypeBase("ring", new ResourceLocation("jewelersconstruct", "textures/items/ring.png"));
    public static final TrinketType TYPE_BELT = new TrinketTypeBase("belt", new ResourceLocation("jewelersconstruct", "textures/items/belt.png"));
    public static final TrinketType TYPE_NECKLACE = new TrinketTypeBase("necklace", new ResourceLocation("jewelersconstruct", "textures/items/necklace.png"));
    public static final Block BLOCK_PART_SHAPER = new BlockPartShaper();
    public static final Block BLOCK_PART_FORGE = new BlockPartForge();
    public static final Item ITEM_CREATIVE_MODIFIER = new ItemCreativeModifier();
    public static final Item ITEM_RING = new ItemJewelry(TYPE_RING, BaubleType.RING);
    public static final Item ITEM_BELT = new ItemJewelry(TYPE_BELT, BaubleType.BELT);
    public static final Item ITEM_NECKLACE = new ItemJewelry(TYPE_NECKLACE, BaubleType.AMULET);
    public static final ItemPart ITEM_PART_BAND = new ItemPart(PART_BAND);
    public static final ItemPart ITEM_PART_BINDING = new ItemPart(PART_BINDING);
    public static final ItemPart ITEM_PART_CHAIN = new ItemPart(PART_CHAIN);
    public static final ItemPart ITEM_PART_BUCKLE = new ItemPart(PART_BUCKLE);
    public static final ItemPart ITEM_PART_GEM = new ItemPart(PART_GEM);

    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent event) {
        for (String s : TempUtils.getOreNames(event.getItemStack())) {
            event.getToolTip().add(s);
        }
        if (JewelryHelper.INPUTS_TO_MODIFIERS.containsKey((Object)event.getItemStack())) {
            Modifier modifier = (Modifier)((Object)JewelryHelper.INPUTS_TO_MODIFIERS.get((Object)event.getItemStack()));
            event.getToolTip().add("JC Modifier: " + JewelersConstruct.PROXY.translate(modifier.getTranslationName(), new Object[0]));
        }
        if (JewelryHelper.INPUTS_TO_MATERIALS.containsKey((Object)event.getItemStack())) {
            Material mat = (Material)((Object)JewelryHelper.INPUTS_TO_MATERIALS.get((Object)event.getItemStack()));
            event.getToolTip().add("JC Material: " + JewelersConstruct.PROXY.translate(mat.getTranslationName(), new Object[0]));
        }
    }

    @SubscribeEvent
    public static void registerModifiers(RegistryEvent.Register<Modifier> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)MODIFIER_VIGOR);
        registry.register((IForgeRegistryEntry)MODIFIER_VITALITY);
        registry.register((IForgeRegistryEntry)MODIFIER_FORTITUDE);
        registry.register((IForgeRegistryEntry)MODIFIER_STURDY);
        registry.register((IForgeRegistryEntry)MODIFIER_LUCK);
        registry.register((IForgeRegistryEntry)MODIFIER_GRASPING);
        registry.register((IForgeRegistryEntry)MODIFIER_SWIFT);
        registry.register((IForgeRegistryEntry)MODIFIER_TRAVELER);
        registry.register((IForgeRegistryEntry)MODIFIER_STEP_UP);
        registry.register((IForgeRegistryEntry)MODIFIER_FLOAT);
        registry.register((IForgeRegistryEntry)MODIFIER_FOOD);
        registry.register((IForgeRegistryEntry)MODIFIER_SATURATION);
        registry.register((IForgeRegistryEntry)MODIFIER_MAGNET);
        JewelryHelper.associateModifier(new ItemStack(Items.field_151008_G), MODIFIER_FLOAT);
        JewelryHelper.associateModifier(new ItemStack(Items.field_151040_l), MODIFIER_VIGOR);
        JewelryHelper.associateModifier(new ItemStack(Items.field_151153_ao), MODIFIER_VITALITY);
        JewelryHelper.associateModifier(new ItemStack((Item)Items.field_151030_Z), MODIFIER_FORTITUDE);
        JewelryHelper.associateModifier(new ItemStack(Blocks.field_150467_bQ), MODIFIER_STURDY);
        JewelryHelper.associateModifier(new ItemStack(Items.field_179556_br), MODIFIER_LUCK);
        JewelryHelper.associateModifier(new ItemStack((Item)Items.field_151112_aM), MODIFIER_GRASPING);
        JewelryHelper.associateModifier(new ItemStack(Items.field_151102_aT), MODIFIER_SWIFT);
        JewelryHelper.associateModifier(new ItemStack(Items.field_151143_au), MODIFIER_TRAVELER);
        JewelryHelper.associateModifier(new ItemStack((Block)Blocks.field_150333_U), MODIFIER_STEP_UP);
        JewelryHelper.associateModifier(new ItemStack(Items.field_151083_be), MODIFIER_FOOD);
        JewelryHelper.associateModifier(new ItemStack(Items.field_151150_bK), MODIFIER_SATURATION);
        JewelryHelper.associateModifier(new ItemStack((Block)Blocks.field_150320_F), MODIFIER_MAGNET);
    }

    @SubscribeEvent
    public static void registerMaterials(RegistryEvent.Register<Material> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)MATERIAL_WOOD);
        registry.register((IForgeRegistryEntry)MATERIAL_FLINT);
        registry.register((IForgeRegistryEntry)MATERIAL_BONE);
        registry.register((IForgeRegistryEntry)MATERIAL_STONE);
        registry.register((IForgeRegistryEntry)MATERIAL_IRON);
        registry.register((IForgeRegistryEntry)MATERIAL_GOLD);
        registry.register((IForgeRegistryEntry)MATERIAL_PRISMARINE);
        registry.register((IForgeRegistryEntry)MATERIAL_EMERALD);
        registry.register((IForgeRegistryEntry)MATERIAL_DIAMOND);
        registry.register((IForgeRegistryEntry)MATERIAL_COPPER);
        registry.register((IForgeRegistryEntry)MATERIAL_BRONZE);
        registry.register((IForgeRegistryEntry)MATERIAL_LEAD);
        registry.register((IForgeRegistryEntry)MATERIAL_SILVER);
        registry.register((IForgeRegistryEntry)MATERIAL_ELECTRUM);
        registry.register((IForgeRegistryEntry)MATERIAL_STEEL);
        AddonManager.getAddons().forEach(addon -> addon.registerMaterials((IForgeRegistry<Material>)registry));
    }

    public static void associateItemsToMaterial() {
        JewelryHelper.associateMaterial("plankWood", MATERIAL_WOOD);
        JewelryHelper.associateMaterial("bone", MATERIAL_BONE);
        JewelryHelper.associateMaterial(Items.field_151145_ak, MATERIAL_FLINT);
        JewelryHelper.associateMaterial("stone", MATERIAL_STONE);
        JewelryHelper.associateMaterial("ingotIron", MATERIAL_IRON);
        JewelryHelper.associateMaterial("plateIron", MATERIAL_IRON);
        JewelryHelper.associateMaterial("ingotGold", MATERIAL_GOLD);
        JewelryHelper.associateMaterial("plateGold", MATERIAL_GOLD);
        JewelryHelper.associateMaterial("gemDiamond", MATERIAL_DIAMOND);
        JewelryHelper.associateMaterial("gemEmerald", MATERIAL_EMERALD);
        JewelryHelper.associateMaterial("gemPrismarine", MATERIAL_PRISMARINE);
        JewelryHelper.associateMaterial("ingotCopper", MATERIAL_COPPER);
        JewelryHelper.associateMaterial("plateCopper", MATERIAL_COPPER);
        JewelryHelper.associateMaterial("inogtBronze", MATERIAL_BRONZE);
        JewelryHelper.associateMaterial("plateBronze", MATERIAL_BRONZE);
        JewelryHelper.associateMaterial("ingotLead", MATERIAL_LEAD);
        JewelryHelper.associateMaterial("plateLead", MATERIAL_LEAD);
        JewelryHelper.associateMaterial("ingotSilver", MATERIAL_SILVER);
        JewelryHelper.associateMaterial("plateSilver", MATERIAL_SILVER);
        JewelryHelper.associateMaterial("ingotElectrum", MATERIAL_ELECTRUM);
        JewelryHelper.associateMaterial("plateElectrum", MATERIAL_ELECTRUM);
        JewelryHelper.associateMaterial("ingotSteel", MATERIAL_STEEL);
        JewelryHelper.associateMaterial("plateSteel", MATERIAL_STEEL);
        AddonManager.getAddons().forEach(addon -> addon.associateMaterials());
    }

    @SubscribeEvent
    public static void registerPartTypes(RegistryEvent.Register<PartType> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)PART_BAND);
        registry.register((IForgeRegistryEntry)PART_BINDING);
        registry.register((IForgeRegistryEntry)PART_CHAIN);
        registry.register((IForgeRegistryEntry)PART_BUCKLE);
        registry.register((IForgeRegistryEntry)PART_GEM);
    }

    @SubscribeEvent
    public static void registerTrinketTypes(RegistryEvent.Register<TrinketType> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)TYPE_RING);
        TYPE_RING.setPartTypes(new PartType[]{PART_BAND, PART_BINDING, PART_GEM});
        registry.register((IForgeRegistryEntry)TYPE_BELT);
        TYPE_BELT.setPartTypes(new PartType[]{PART_BAND, PART_BAND, PART_BUCKLE, PART_GEM});
        registry.register((IForgeRegistryEntry)TYPE_NECKLACE);
        TYPE_NECKLACE.setPartTypes(new PartType[]{PART_CHAIN, PART_GEM, PART_BINDING});
    }

    public static void registerBlocks(RegistryHelper registry) {
        GameRegistry.registerTileEntity(TileEntityPartShaper.class, (String)"part_shaper");
        GameRegistry.registerTileEntity(TileEntityTrinketForge.class, (String)"trinket_forge");
        registry.registerBlock(BLOCK_PART_SHAPER, "part_shaper");
        registry.registerBlock(BLOCK_PART_FORGE, "part_forge");
    }

    public static void registerItems(RegistryHelper registry) {
        registry.registerItem(ITEM_RING, "ring");
        registry.registerItem(ITEM_BELT, "belt");
        registry.registerItem(ITEM_NECKLACE, "necklace");
        registry.registerItem((Item)ITEM_PART_BAND, "part_band");
        registry.registerItem((Item)ITEM_PART_BINDING, "part_binding");
        registry.registerItem((Item)ITEM_PART_CHAIN, "part_chain");
        registry.registerItem((Item)ITEM_PART_BUCKLE, "part_buckle");
        registry.registerItem((Item)ITEM_PART_GEM, "part_gem");
        registry.registerItem(ITEM_CREATIVE_MODIFIER, "creative_modifier");
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> registry) {
        registry.getRegistry().register(new ShapedOreRecipe(new ResourceLocation("jewelersconstruct", "part_forge"), new ItemStack(BLOCK_PART_SHAPER), new Object[]{"sis", "s s", "sss", Character.valueOf('s'), "stone", Character.valueOf('i'), Blocks.field_150411_aY}).setRegistryName(new ResourceLocation("jewelersconstruct", "part_forge")));
        registry.getRegistry().register(new ShapedOreRecipe(new ResourceLocation("jewelersconstruct", "part_shaper"), new ItemStack(BLOCK_PART_FORGE), new Object[]{"sss", "pwp", "ppp", Character.valueOf('s'), "slabWood", Character.valueOf('w'), "logWood", Character.valueOf('p'), "plankWood"}).setRegistryName(new ResourceLocation("jewelersconstruct", "part_shaper")));
    }
}

