/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gens.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import ladysnake.gens.world.ComponentGensPieces;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenGens
extends MapGenStructure {
    public static List<Biome> HAR_SPAWN_BIOMES = Arrays.asList(Biomes.field_76769_d, Biomes.field_150589_Z);
    private final int gridUnit;
    private final int size;

    public static void registerStructures() {
        MapGenStructureIO.func_143034_b(Start.class, (String)"gens:Village");
    }

    public MapGenGens(int gridUnit, int size) {
        this.gridUnit = gridUnit;
        this.size = size;
    }

    public String func_143025_a() {
        return "Gens";
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return MapGenGens.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.gridUnit, (int)(this.gridUnit / 4), (int)16737709, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int gridX = Math.floorDiv(chunkX, this.gridUnit);
        int gridZ = Math.floorDiv(chunkZ, this.gridUnit);
        Random random = this.field_75039_c.func_72843_D(gridX, gridZ, 16737709);
        int gridChunkX = gridX * this.gridUnit + random.nextInt(3 * this.gridUnit / 4);
        int gridChunkZ = gridZ * this.gridUnit + random.nextInt(3 * this.gridUnit / 4);
        return chunkX == gridChunkX && chunkZ == gridChunkZ && this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 16, HAR_SPAWN_BIOMES);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ, this.size);
    }

    static {
        MapGenGens.registerStructures();
        ComponentGensPieces.registerStructureComponents();
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World world, Random rand, int x, int z, int size) {
            super(x, z);
            int i;
            ArrayList<ComponentGensPieces.StructureType> plans = new ArrayList<ComponentGensPieces.StructureType>();
            plans.add(ComponentGensPieces.HAR_CAMPFIRE);
            plans.add(ComponentGensPieces.HAR_STASH);
            if (rand.nextInt(2) == 0) {
                plans.add(ComponentGensPieces.HAR_FORGE);
            }
            for (i = 1 + rand.nextInt(3); i >= 0; --i) {
                plans.add(ComponentGensPieces.HAR_DORM);
            }
            for (i = 1 + rand.nextInt(2); i >= 0; --i) {
                plans.add(ComponentGensPieces.HAR_STORAGE);
            }
            if (rand.nextBoolean()) {
                plans.add(ComponentGensPieces.HAR_GUARD_TOWER);
            }
            if (rand.nextBoolean()) {
                plans.add(ComponentGensPieces.HAR_RABBIT_PEN);
            }
            Collections.shuffle(plans, rand);
            for (ComponentGensPieces.StructureType plan : plans) {
                ComponentGensPieces.Feature component = null;
                if (this.field_75075_a.isEmpty()) {
                    component = new ComponentGensPieces.Feature(rand, x * 16, 64, z * 16, plan);
                } else {
                    while (component == null) {
                        StructureComponent otherComponent = (StructureComponent)this.field_75075_a.get(rand.nextInt(this.field_75075_a.size()));
                        double r = 9.0 + 5.0 * rand.nextDouble();
                        double theta = rand.nextDouble() * Math.PI * 2.0;
                        StructureBoundingBox box = otherComponent.func_74874_b();
                        int candidateX = MathHelper.func_76128_c((double)((double)box.field_78897_a + Math.sin(theta) * r));
                        int candidateY = MathHelper.func_76128_c((double)((double)box.field_78896_c + Math.cos(theta) * r));
                        ComponentGensPieces.Feature candidateComponent = new ComponentGensPieces.Feature(rand, candidateX, 64, candidateY, plan);
                        if (!this.field_75075_a.stream().noneMatch(collidingComponent -> candidateComponent.func_74874_b().func_78884_a(collidingComponent.func_74874_b()))) continue;
                        component = candidateComponent;
                    }
                }
                this.field_75075_a.add(component);
            }
            this.func_75072_c();
        }
    }
}

