/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gens.world;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ladysnake.gens.entity.EntityGensMerchant;
import ladysnake.gens.entity.EntityGensSoldier;
import ladysnake.gens.entity.EntityGensVillager;
import ladysnake.gens.init.ModEthnicities;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class ComponentGensPieces {
    private static final Map<ResourceLocation, StructureType> subTypeRegistry = new HashMap<ResourceLocation, StructureType>();
    public static final StructureType TEST = new StructureType(new ResourceLocation("gens", "test/test"), 8, 8, 8, 0, Collections.emptyList(), 0, 0);
    public static final StructureType HAR_CAMPFIRE = new StructureType(new ResourceLocation("gens", "har/har_campfire"), 9, 9, 9, 0, Arrays.asList(new BlockPos(2, 1, 2), new BlockPos(6, 1, 2), new BlockPos(2, 1, 6), new BlockPos(6, 1, 6)), 0, 1);
    public static final StructureType HAR_DORM = new StructureType(new ResourceLocation("gens", "har/har_dorm"), 9, 9, 9, 0, Arrays.asList(new BlockPos(3, 1, 3), new BlockPos(5, 1, 3), new BlockPos(3, 1, 5), new BlockPos(5, 1, 5)), 1, 3);
    public static final StructureType HAR_FORGE = new StructureType(new ResourceLocation("gens", "har/har_forge"), 9, 9, 9, 0, Arrays.asList(new BlockPos(3, 1, 3), new BlockPos(5, 1, 3), new BlockPos(3, 1, 5), new BlockPos(5, 1, 5)), 1, 2);
    public static final StructureType HAR_STORAGE = new StructureType(new ResourceLocation("gens", "har/har_storage"), 9, 9, 9, 0, Arrays.asList(new BlockPos(3, 1, 3), new BlockPos(5, 1, 3), new BlockPos(3, 1, 5), new BlockPos(5, 1, 5)), 0, 2);
    public static final StructureType HAR_STASH = new StructureType(new ResourceLocation("gens", "har/har_stash"), 3, 6, 3, -2, Collections.emptyList(), 0, 0);
    public static final StructureType HAR_GUARD_TOWER = new StructureType(new ResourceLocation("gens", "har/har_guard_tower"), 13, 7, 13, 0, Arrays.asList(new BlockPos(3, 6, 3), new BlockPos(9, 6, 3), new BlockPos(3, 6, 9), new BlockPos(9, 6, 9)), 0, 2);
    public static final StructureType HAR_RABBIT_PEN = new StructureType(new ResourceLocation("gens", "har/har_rabbit_pen"), 13, 5, 13, -3, Collections.emptyList(), 0, 0);

    private static void registerStructureType(StructureType structureType) {
        subTypeRegistry.put(structureType.id, structureType);
    }

    public static void registerStructureComponents() {
        MapGenStructureIO.func_143031_a(Feature.class, (String)"gens:feature");
        ComponentGensPieces.registerStructureType(TEST);
        ComponentGensPieces.registerStructureType(HAR_CAMPFIRE);
        ComponentGensPieces.registerStructureType(HAR_DORM);
        ComponentGensPieces.registerStructureType(HAR_FORGE);
        ComponentGensPieces.registerStructureType(HAR_STORAGE);
    }

    public static class Feature
    extends StructureComponent {
        protected int horizontalPos = -1;
        protected StructureType structureType;

        public Feature() {
        }

        public Feature(Random rand, int x, int y, int z, StructureType structureType) {
            super(0);
            this.structureType = structureType;
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, y, z, x + structureType.sizeX - 1, y + structureType.sizeY - 1, z + structureType.sizeZ - 1) : new StructureBoundingBox(x, y, z, x + structureType.sizeZ - 1, y + structureType.sizeY - 1, z + structureType.sizeX - 1);
        }

        protected boolean offsetToAverageGroundLevel(World worldIn, StructureBoundingBox structurebb, int yOffset) {
            if (this.horizontalPos >= 0) {
                return true;
            }
            int i = 0;
            int j = 0;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
                for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                    pos.func_181079_c(l, 64, k);
                    if (!structurebb.func_175898_b((Vec3i)pos)) continue;
                    i += Math.max(worldIn.func_175672_r((BlockPos)pos).func_177956_o(), worldIn.field_73011_w.func_76557_i());
                    ++j;
                }
            }
            if (j == 0) {
                return false;
            }
            this.horizontalPos = i / j;
            this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset + this.structureType.offsetY, 0);
            return true;
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("HPos", this.horizontalPos);
            tagCompound.func_74778_a("StructureType", this.structureType.id.toString());
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            this.horizontalPos = tagCompound.func_74762_e("HPos");
            this.structureType = (StructureType)subTypeRegistry.get(new ResourceLocation(tagCompound.func_74779_i("StructureType")));
        }

        public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
            if (!this.offsetToAverageGroundLevel(worldIn, structureBoundingBoxIn, -1)) {
                return false;
            }
            StructureBoundingBox box = this.func_74874_b();
            BlockPos middle = new BlockPos((box.field_78897_a + box.field_78893_d) / 2, (box.field_78895_b + box.field_78894_e) / 2, (box.field_78896_c + box.field_78892_f) / 2);
            if (structureBoundingBoxIn.func_175898_b((Vec3i)middle)) {
                PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(this.field_186168_b).func_186225_a(Blocks.field_189881_dj).func_186223_a(box);
                BlockPos minPos = new BlockPos(box.field_78897_a, box.field_78895_b, box.field_78896_c);
                BlockPos zeroPos = Template.func_191157_a((BlockPos)minPos, (Mirror)this.field_186168_b, (Rotation)this.field_186169_c, (int)box.func_78883_b(), (int)box.func_78880_d());
                MinecraftServer minecraftserver = worldIn.func_73046_m();
                TemplateManager templatemanager = worldIn.func_72860_G().func_186340_h();
                Template template = templatemanager.func_186237_a(minecraftserver, this.structureType.id);
                template.func_186260_a(worldIn, zeroPos, placementsettings);
                for (BlockPos.MutableBlockPos pos : BlockPos.func_191531_b((int)box.field_78897_a, (int)box.field_78895_b, (int)box.field_78896_c, (int)box.field_78893_d, (int)box.field_78895_b, (int)box.field_78892_f)) {
                    int initialY = pos.func_177956_o();
                    for (int y = box.field_78895_b - 1; y >= 0; --y) {
                        pos.func_185336_p(y);
                        if (worldIn.func_175677_d((BlockPos)pos, true)) break;
                        worldIn.func_175656_a((BlockPos)pos, Blocks.field_150354_m.func_176223_P());
                    }
                    pos.func_185336_p(initialY);
                }
                this.spawnVillagers(worldIn, randomIn, this.structureType.minVillagers + randomIn.nextInt(1 + this.structureType.maxVillagers - this.structureType.minVillagers));
                return true;
            }
            return false;
        }

        protected void spawnVillagers(World worldIn, Random rand, int count) {
            for (int i = 0; i < count; ++i) {
                EntityGensVillager villager;
                BlockPos pos = (BlockPos)this.structureType.spawnPositions.get(rand.nextInt(this.structureType.spawnPositions.size()));
                int x = this.func_74865_a(pos.func_177958_n(), pos.func_177952_p());
                int y = this.func_74862_a(pos.func_177956_o());
                int z = this.func_74873_b(pos.func_177958_n(), pos.func_177952_p());
                switch (rand.nextInt(3)) {
                    case 0: {
                        villager = new EntityGensMerchant(worldIn, ModEthnicities.HAR.getProfession("dealer"));
                        break;
                    }
                    case 1: {
                        villager = new EntityGensMerchant(worldIn, ModEthnicities.HAR.getProfession("member"));
                        break;
                    }
                    default: {
                        villager = new EntityGensSoldier(worldIn);
                    }
                }
                villager.func_70012_b((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
                worldIn.func_72838_d((Entity)villager);
            }
        }
    }

    public static class StructureType {
        private final ResourceLocation id;
        private final int sizeX;
        private final int sizeY;
        private final int sizeZ;
        private final int offsetY;
        private final List<BlockPos> spawnPositions;
        private final int minVillagers;
        private final int maxVillagers;

        private StructureType(ResourceLocation id, int sizeX, int sizeY, int sizeZ, int offsetY, List<BlockPos> spawnPositions, int minVillagers, int maxVillagers) {
            this.id = id;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
            this.offsetY = offsetY;
            this.spawnPositions = spawnPositions;
            this.minVillagers = minVillagers;
            this.maxVillagers = maxVillagers;
        }
    }
}

