/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gens.item;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladylib.client.ICustomLocation;
import ladylib.misc.ItemUtil;
import ladysnake.gens.Gens;
import ladysnake.gens.item.ItemScimitar;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="gens")
public class ItemSma
extends Item
implements ICustomLocation {
    public static final String NBT_SMA = "gens:sma";
    private static final Random rand = new Random();
    private Types type;

    public ItemSma(Types type) {
        this.type = type;
        this.func_77642_a(Items.field_151069_bo);
    }

    @SubscribeEvent
    public static void onPlayerInteractRightClickItem(PlayerInteractEvent.RightClickBlock event) {
        int level;
        IBlockState block;
        if (ItemSma.getSmaType(event.getItemStack()).isPresent() && (block = event.getWorld().func_180495_p(event.getPos())).func_177230_c() instanceof BlockCauldron && (level = ((Integer)block.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) > 0) {
            ItemSma.setSmaType(event.getItemStack(), null);
            ((BlockCauldron)block.func_177230_c()).func_176590_a(event.getWorld(), event.getPos(), block, level - 1);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        NBTTagCompound smaCompound = stack.func_179543_a(NBT_SMA);
        Types smaType = ItemSma.getSmaType(smaCompound);
        if (smaType != null && event.getTarget() instanceof EntityLivingBase) {
            smaType.applyEffect((EntityLivingBase)event.getTarget(), stack.func_77973_b() instanceof ItemScimitar ? 2 : 1);
            if (!event.getEntityPlayer().func_184812_l_()) {
                smaCompound.func_74768_a("uses", smaCompound.func_74762_e("uses") - 1);
            }
        }
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        this.getType().applyEffect(entityLiving, 2);
        return new ItemStack(Items.field_151069_bo);
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public static ItemStack getRandomSmaBottle() {
        Item smaBottle = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("gens", "har_sma_" + (Object)((Object)Types.VALUES[rand.nextInt(Types.VALUES.length)])));
        if (smaBottle == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(smaBottle);
    }

    public Types getType() {
        return this.type;
    }

    public static Optional<Types> getSmaType(ItemStack stack) {
        NBTTagCompound compound = stack.func_179543_a(NBT_SMA);
        return Optional.ofNullable(ItemSma.getSmaType(compound));
    }

    @Nullable
    private static Types getSmaType(NBTTagCompound smaNBT) {
        if (smaNBT != null) {
            try {
                return Types.valueOf(smaNBT.func_74779_i("type"));
            }
            catch (IllegalArgumentException e) {
                Gens.LOGGER.error("Unrecognized sma type", (Throwable)e);
            }
        }
        return null;
    }

    public static void setSmaType(ItemStack stack, Types smaType) {
        if (smaType == null && stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(NBT_SMA);
        } else {
            NBTTagCompound compound = ItemUtil.getOrCreateCompound((ItemStack)stack);
            NBTTagCompound smaNBT = new NBTTagCompound();
            smaNBT.func_74778_a("type", smaType.name());
            smaNBT.func_74768_a("uses", 30);
            compound.func_74782_a(NBT_SMA, (NBTBase)smaNBT);
        }
    }

    public ModelResourceLocation getModelLocation() {
        return new ModelResourceLocation("gens:har_sma");
    }

    @Mod.EventBusSubscriber(modid="gens", value={Side.CLIENT})
    public static class SmaClientHandler {
        @SubscribeEvent
        public static void onItemTooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            NBTTagCompound smaCompound = stack.func_179543_a(ItemSma.NBT_SMA);
            Types smaType = ItemSma.getSmaType(smaCompound);
            if (smaType != null) {
                event.getToolTip().add(I18n.func_135052_a((String)"gens.tooltip.sma", (Object[])new Object[]{smaType, smaCompound.func_74762_e("uses")}));
            }
        }
    }

    public static enum Types {
        SMA(MobEffects.field_76436_u, 1),
        ZIL(MobEffects.field_82731_v, 0),
        WAQ(MobEffects.field_76421_d, 1),
        JUE(MobEffects.field_76438_s, 1);

        public static final Types[] VALUES;
        private final int color;
        private final Potion potion;
        private final int amplifier;

        private Types(Potion potion, int amplifier) {
            this.color = potion.func_76401_j();
            this.potion = potion;
            this.amplifier = amplifier;
        }

        public int getColor() {
            return this.color;
        }

        public void applyEffect(EntityLivingBase entityIn, int potencyModifier) {
            entityIn.func_70690_d(new PotionEffect(this.potion, 200, (this.amplifier + 1) * potencyModifier - 1));
        }

        static {
            VALUES = Types.values();
        }
    }
}

