/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gens.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import ladysnake.gens.entity.GensEthnicity;
import ladysnake.gens.entity.GensProfession;
import ladysnake.gens.init.ModEthnicities;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class EntityGensVillager
extends EntityAgeable
implements INpc,
IEntityAdditionalSpawnData {
    protected GensProfession profession;
    protected int skin;

    public EntityGensVillager(World worldIn) {
        this(worldIn, ModEthnicities.HAR.getProfession("dealer"));
    }

    public EntityGensVillager(World worldIn, GensProfession profession) {
        super(worldIn);
        this.profession = profession;
        this.skin = this.field_70146_Z.nextInt(profession.getTextures().length);
        this.func_70105_a(0.6f, 1.95f);
    }

    public ResourceLocation getTexture() {
        ResourceLocation[] professionTextures = this.profession.getTextures();
        if (this.skin > professionTextures.length) {
            this.skin = 0;
        }
        return professionTextures[this.skin];
    }

    public ResourceLocation getClothesTexture() {
        ResourceLocation[] professionTextures = this.profession.getClothesTextures();
        if (this.skin > professionTextures.length) {
            this.skin = 0;
        }
        return professionTextures[this.skin];
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public GensProfession getProfession() {
        return this.profession;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.65);
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack playerHeldItem;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack heldItem = this.func_184614_ca();
                ItemStack itemStack = playerHeldItem = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!heldItem.func_190926_b() && !playerHeldItem.func_190926_b() && heldItem.func_77973_b().canDisableShield(heldItem, playerHeldItem, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && playerHeldItem.func_77973_b().isShield(playerHeldItem, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(playerHeldItem.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("skin", this.skin);
        compound.func_74778_a("ethnicity", this.profession.getParent().getRegistryName().toString());
        compound.func_74778_a("profession", this.profession.getName());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.skin = compound.func_74762_e("skin");
        GensEthnicity ethnicity = (GensEthnicity)GensEthnicity.REGISTRY.getValue(new ResourceLocation(compound.func_74779_i("ethnicity")));
        if (ethnicity != null) {
            this.profession = ethnicity.getProfession(compound.func_74779_i("profession"));
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        PacketBuffer buf = new PacketBuffer(buffer);
        buf.func_180714_a(this.profession.getParent().getRegistryName().toString());
        buf.func_180714_a(this.profession.getName());
        buf.writeInt(this.skin);
    }

    public void readSpawnData(ByteBuf additionalData) {
        PacketBuffer buf = new PacketBuffer(additionalData);
        GensEthnicity ethnicity = (GensEthnicity)GensEthnicity.REGISTRY.getValue(new ResourceLocation(buf.func_150789_c(40)));
        String profession = buf.func_150789_c(40);
        if (ethnicity != null) {
            this.profession = ethnicity.getProfession(profession);
        }
        this.skin = buf.readInt();
    }
}

