/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.gens.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ladysnake.gens.entity.EntityGensVillager;
import ladysnake.gens.entity.GensProfession;
import ladysnake.gens.entity.ai.EntityGensAILookAtTradePlayer;
import ladysnake.gens.entity.ai.EntityGensAITradePlayer;
import ladysnake.gens.init.ModEthnicities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class EntityGensMerchant
extends EntityGensVillager
implements IMerchant {
    private EntityPlayer customer;
    private MerchantRecipeList buyingList;

    public EntityGensMerchant(World worldIn) {
        this(worldIn, ModEthnicities.HAR.getProfession("dealer"));
    }

    public EntityGensMerchant(World worldIn, GensProfession profession) {
        super(worldIn, profession);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityGensAITradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityGensAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityEvoker.class, 12.0f, 0.8, 0.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityVindicator.class, 8.0f, 0.8, 0.8));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityVex.class, 8.0f, 0.6, 0.6));
    }

    public boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (!(this.func_190669_a(itemstack, ((Object)((Object)this)).getClass()) || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            if (this.buyingList == null) {
                this.populateBuyingList();
            }
            if (hand == EnumHand.MAIN_HAND) {
                player.func_71029_a(StatList.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K && !this.buyingList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.buyingList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private void populateBuyingList() {
        this.buyingList = new MerchantRecipeList();
        for (EntityVillager.ITradeList tradeList : this.profession.getTrades()) {
            tradeList.func_190888_a((IMerchant)this, this.buyingList, this.field_70146_Z);
        }
    }

    public boolean isTrading() {
        return this.customer != null;
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable ageable) {
        EntityGensMerchant desertPerson = new EntityGensMerchant(this.field_70170_p);
        desertPerson.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)desertPerson)), null);
        return desertPerson;
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.customer = player;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.customer;
    }

    @Nullable
    public MerchantRecipeList func_70934_b(@Nonnull EntityPlayer player) {
        return this.buyingList;
    }

    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    public void func_70933_a(@Nonnull MerchantRecipe recipe) {
    }

    public void func_110297_a_(@Nonnull ItemStack stack) {
    }

    @Nonnull
    public World func_190670_t_() {
        return this.field_70170_p;
    }

    @Nonnull
    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.buyingList != null) {
            compound.func_74782_a("tradeList", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("tradeList")) {
            this.buyingList = new MerchantRecipeList(compound.func_74775_l("tradeList"));
        }
    }
}

